/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ChartOfAccountCategories;
import classes.ChartOfAccountTypes;
import classes.ChartOfAccountsGroups;
import classes.ChartOfAccountsSubCategories;
import classes.Config;
import classes.Currency;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Account {
    private String accountNumber;
    private ChartOfAccountTypes type;
    private ChartOfAccountCategories category;
    private ChartOfAccountsSubCategories subCategory;
    private ChartOfAccountsGroups group;
    private String accountName;
    private double accountBalance;
    private int noOfGlEntries;
    private String lastTransactionDate;
    private boolean postingAllowed;
    private String accountBalanceString;
    private String noOfTransactionString;
    private Currency currency;

    public Account(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Account() {
    }

    public Account(String accountNumber, String accountName) {
        this.accountNumber = accountNumber;
        this.accountName = accountName;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public ChartOfAccountTypes getType() {
        return this.type;
    }

    public void setType(ChartOfAccountTypes type) {
        this.type = type;
    }

    public ChartOfAccountCategories getCategory() {
        return this.category;
    }

    public void setCategory(ChartOfAccountCategories category) {
        this.category = category;
    }

    public ChartOfAccountsSubCategories getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(ChartOfAccountsSubCategories subCategory) {
        this.subCategory = subCategory;
    }

    public ChartOfAccountsGroups getGroup() {
        return this.group;
    }

    public void setGroup(ChartOfAccountsGroups group) {
        this.group = group;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public double getAccountBalance() {
        return this.accountBalance;
    }

    public void setAccountBalance(double accountBalance) {
        this.accountBalance = accountBalance;
    }

    public int getNoOfGlEntries() {
        return this.noOfGlEntries;
    }

    public void setNoOfGlEntries(int noOfGlEntries) {
        this.noOfGlEntries = noOfGlEntries;
    }

    public String getLastTransactionDate() {
        return this.lastTransactionDate;
    }

    public void setLastTransactionDate(String lastTransactionDate) {
        this.lastTransactionDate = lastTransactionDate;
    }

    public boolean isPostingAllowed() {
        return this.postingAllowed;
    }

    public void setPostingAllowed(boolean postingAllowed) {
        this.postingAllowed = postingAllowed;
    }

    public String getAccountBalanceString() {
        return Config.formatNumber(this.accountBalance);
    }

    public void setAccountBalanceString(String accountBalanceString) {
        this.accountBalanceString = accountBalanceString;
    }

    public String getNoOfTransactionString() {
        return Config.formatNumber(this.noOfGlEntries);
    }

    public void setNoOfTransactionString(String noOfTransactionString) {
        this.noOfTransactionString = noOfTransactionString;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public static ObservableList<Account> getAccounts(User user) {
        ObservableList allAccounts = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response2 = Config.loadDataFromPhp("masterfetch?type=glaccounts", params, user);
            System.out.println(response2);
            Gson g = new Gson();
            Object[] accountFromJson = (Account[])g.fromJson(response2, Account[].class);
            allAccounts = FXCollections.observableArrayList((Object[])accountFromJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allAccounts;
    }

    public ObservableList<Account> getAccounts(User user, Map<String, Object> params) {
        ObservableList allAccounts = FXCollections.observableArrayList();
        try {
            String response2 = Config.loadDataFromPhp("masterfetch?type=glaccounts", params, user);
            System.out.println(response2);
            Gson g = new Gson();
            Object[] accountFromJson = (Account[])g.fromJson(response2, Account[].class);
            allAccounts = FXCollections.observableArrayList((Object[])accountFromJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allAccounts;
    }

    public String toString() {
        return this.accountName;
    }
}

