/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.AllowancesDeductions;
import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.AllocateAllowanceDeduction;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;

public class AllowanceDeductionMatrix {
    private User user;
    private Employee employee;
    private AllowancesDeductions allowanceDeduction;
    private String calculationMethod;
    private double amountRate;
    private String startDate;
    private String endDate;
    private boolean disabled;
    private String type;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public AllowancesDeductions getAllowanceDeduction() {
        return this.allowanceDeduction;
    }

    public void setAllowanceDeduction(AllowancesDeductions allowanceDeduction) {
        this.allowanceDeduction = allowanceDeduction;
    }

    public String getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(String calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public double getAmountRate() {
        return this.amountRate;
    }

    public String getAmountRateString() {
        String postFix = this.getCalculationMethod().equalsIgnoreCase("Percentage of Basic Salary") ? " %" : "";
        return Config.formatNumber(this.amountRate) + postFix;
    }

    public void setAmountRate(double amountRate) {
        this.amountRate = amountRate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CheckBox getDisabledCheck() {
        CheckBox checkBox = new CheckBox();
        checkBox.setSelected(this.isDisabled());
        checkBox.setDisable(true);
        return checkBox;
    }

    public Button getDelete() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("employeeNo", this.getEmployee().getEmployeeNumber());
                params.put("type", this.getType());
                params.put("code", this.getAllowanceDeduction().getCode());
                String response = Config.loadDataFromPhp("masterdelete?type=allowancedeductionmatrix", params, this.getUser());
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                AllocateAllowanceDeduction.publicNotificationPane.setText(jr.getMessage());
                AllocateAllowanceDeduction.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                AllocateAllowanceDeduction.publicNotificationPane.show();
                if (jr.isStatus()) {
                    AllocateAllowanceDeduction.publicTable.setItems(this.getMatrix(this.getType(), this.getEmployee().getEmployeeNumber(), this.getUser()));
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        return deleteButton;
    }

    public ObservableList<AllowanceDeductionMatrix> getMatrix(String type, String employeeNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("employeeNo", employeeNo);
        params.put("type", type);
        String response = Config.loadDataFromPhp("masterfetch?type=allowancedeductionmatrix", params, user);
        System.out.println(response);
        ObservableList myEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, AllowanceDeductionMatrix[].class)));
        ObservableList toReturn = FXCollections.observableArrayList();
        for (AllowanceDeductionMatrix singleEntry : myEntries) {
            singleEntry.setUser(user);
            toReturn.add((Object)singleEntry);
        }
        return toReturn;
    }
}

