/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.FixedAssets;
import classes.Investment;
import classes.PostingGroup;
import classes.User;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class BalanceSheet {
    private int code;
    private String name;
    private String createdOn;
    private String createdBy;
    private boolean includeLoans;
    private boolean includeDeposits;
    private boolean includeInterestOnMemberDeposits;
    private boolean includeShareCapital;
    private boolean includeReserves;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public boolean isIncludeLoans() {
        return this.includeLoans;
    }

    public void setIncludeLoans(boolean includeLoans) {
        this.includeLoans = includeLoans;
    }

    public boolean isIncludeDeposits() {
        return this.includeDeposits;
    }

    public void setIncludeDeposits(boolean includeDeposits) {
        this.includeDeposits = includeDeposits;
    }

    public boolean isIncludeInterestOnMemberDeposits() {
        return this.includeInterestOnMemberDeposits;
    }

    public void setIncludeInterestOnMemberDeposits(boolean includeInterestOnMemberDeposits) {
        this.includeInterestOnMemberDeposits = includeInterestOnMemberDeposits;
    }

    public boolean isIncludeShareCapital() {
        return this.includeShareCapital;
    }

    public void setIncludeShareCapital(boolean includeShareCapital) {
        this.includeShareCapital = includeShareCapital;
    }

    public boolean isIncludeReserves() {
        return this.includeReserves;
    }

    public void setIncludeReserves(boolean includeReserves) {
        this.includeReserves = includeReserves;
    }

    public class BalanceSheetFixedAsset {
        private FixedAssets fixedAsset;
        private boolean include;

        public FixedAssets getFixedAsset() {
            return this.fixedAsset;
        }

        public void setFixedAsset(FixedAssets fixedAsset) {
            this.fixedAsset = fixedAsset;
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public CheckBox getCheckInclude() {
            CheckBox check = new CheckBox();
            check.setSelected(this.isInclude());
            check.setOnAction(e -> this.setInclude(check.isSelected()));
            return check;
        }

        public ObservableList<BalanceSheetFixedAsset> getAllFixedAssets(User user) {
            ObservableList allAssets = FXCollections.observableArrayList();
            ObservableList<FixedAssets> myAssets = new FixedAssets().getAllAssets(user);
            for (FixedAssets fa : myAssets) {
                BalanceSheetFixedAsset asset = new BalanceSheetFixedAsset();
                asset.setFixedAsset(fa);
                asset.setInclude(false);
                allAssets.add((Object)asset);
            }
            return allAssets;
        }
    }

    public class BalanceSheetInvestment {
        private Investment investment;
        private boolean include;

        public Investment getInvestment() {
            return this.investment;
        }

        public void setInvestment(Investment investment) {
            this.investment = investment;
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public CheckBox getCheckInclude() {
            CheckBox check = new CheckBox();
            check.setSelected(this.isInclude());
            check.setOnAction(e -> this.setInclude(check.isSelected()));
            return check;
        }

        public ObservableList<BalanceSheetInvestment> getAllInvestments(User user) {
            ObservableList allInvestments = FXCollections.observableArrayList();
            ObservableList<Investment> myInvestments = new Investment().getAllInvestments(user);
            for (Investment investment : myInvestments) {
                BalanceSheetInvestment myInvestment = new BalanceSheetInvestment();
                myInvestment.setInvestment(investment);
                myInvestment.setInclude(false);
                allInvestments.add((Object)myInvestment);
            }
            return allInvestments;
        }
    }

    public class BalanceSheetPostingGroup {
        private PostingGroup group;
        private boolean include;

        public PostingGroup getGroup() {
            return this.group;
        }

        public void setGroup(PostingGroup group) {
            this.group = group;
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public CheckBox getCheckInclude() {
            CheckBox check = new CheckBox();
            check.setSelected(this.isInclude());
            check.setOnAction(e -> this.setInclude(check.isSelected()));
            return check;
        }

        public ObservableList<BalanceSheetPostingGroup> getPostingGroups(int category, User user) {
            ObservableList myGroups = FXCollections.observableArrayList();
            ObservableList<PostingGroup> myPostingGroups = new PostingGroup().getAllPostingGroups(category, user);
            for (PostingGroup group : myPostingGroups) {
                BalanceSheetPostingGroup tGroup = new BalanceSheetPostingGroup();
                tGroup.setGroup(group);
                tGroup.setInclude(false);
                myGroups.add((Object)tGroup);
            }
            return myGroups;
        }
    }

    public class BalanceSheetBanks {
        private Bank bank;
        private boolean include;

        public Bank getBank() {
            return this.bank;
        }

        public void setBank(Bank bank) {
            this.bank = bank;
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public CheckBox getCheckInclude() {
            CheckBox check = new CheckBox();
            check.setSelected(this.isInclude());
            check.setOnAction(e -> this.setInclude(check.isSelected()));
            return check;
        }

        public ObservableList<BalanceSheetBanks> getAllBanks(User user) {
            ObservableList allBanks = FXCollections.observableArrayList();
            ObservableList<Bank> myBanks = Bank.getAllBanks(user);
            for (Bank myBank : myBanks) {
                BalanceSheetBanks entry = new BalanceSheetBanks();
                entry.setBank(myBank);
                entry.setInclude(false);
                allBanks.add((Object)entry);
            }
            return allBanks;
        }
    }
}

