/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ChargeItem;
import classes.Config;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class BillOfMaterial {
    private int id;
    private String computationMethod;
    private String itemType;
    private String itemCode;
    private String description;
    private ShopItem item;
    private ChargeItem service;
    private double quantity;
    private double unitPrice;
    private double totalAmount;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getComputationMethod() {
        return this.computationMethod;
    }

    public void setComputationMethod(String computationMethod) {
        this.computationMethod = computationMethod;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public ShopItem getItem() {
        return this.item;
    }

    public void setItem(ShopItem item) {
        this.item = item;
    }

    public ChargeItem getService() {
        return this.service;
    }

    public void setService(ChargeItem service) {
        this.service = service;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public ObservableList<BillOfMaterial> getAllMaterials(String parentCode, User user) {
        ObservableList materials = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("parentCode", parentCode);
            String response = Config.loadDataFromPhp("masterfetch?type=bill_of_materials", params, user);
            materials = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, BillOfMaterial[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return materials;
    }

    public ObservableList<BillOfMaterial> getProductionReturnMaterials(String headerNo, String type, User user) {
        ObservableList materials = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("headerNo", headerNo);
            params.put("type", type);
            String response = Config.loadDataFromPhp("masterfetch?type=production_return_lines", params, user);
            materials = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, BillOfMaterial[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return materials;
    }
}

