/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Floor;
import classes.JsonResponses;
import classes.PostingGroup;
import classes.PricingGroup;
import classes.Property;
import classes.Region;
import classes.Units;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Customer {
    private String customerNumber;
    private String customerName;
    private String customerId;
    private String customerPhone;
    private String customerEmail;
    private double balance;
    private String kraPin;
    private String dateOfBirth;
    private PostingGroup customerPostingGroup;
    private String contactPersonName;
    private String contactPersonPhone;
    private String contactPersonJobPosition;
    private String contactPersonEmail;
    private String gender;
    private String image;
    private Region region;
    private Vendor salesRep;
    private Property property;
    private Floor floor;
    private Units unit;
    private String kinName;
    private String kinIdNo;
    private String kinPhoneNo;
    private String kinRelationship;
    private String entryDate;
    private PricingGroup pricingGroup;
    private double creditLimit;
    private double creditPeriod;
    private String remarks;
    private String dmsNo;

    public Customer() {
    }

    public String getKraPin() {
        return this.kraPin;
    }

    public void setKraPin(String kraPin) {
        this.kraPin = kraPin;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PostingGroup getCustomerPostingGroup() {
        return this.customerPostingGroup;
    }

    public void setCustomerPostingGroup(PostingGroup customerPostingGroup) {
        this.customerPostingGroup = customerPostingGroup;
    }

    public Customer(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public void setCustomerEmail(String customerEmail) {
        this.customerEmail = customerEmail;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getBalanceString() {
        return Config.formatNumber(this.balance);
    }

    public void setBalanceString(String balanceString) {
    }

    public String getContactPersonName() {
        return this.contactPersonName;
    }

    public void setContactPersonName(String contactPersonName) {
        this.contactPersonName = contactPersonName;
    }

    public String getContactPersonPhone() {
        return this.contactPersonPhone;
    }

    public void setContactPersonPhone(String contactPersonPhone) {
        this.contactPersonPhone = contactPersonPhone;
    }

    public String getContactPersonJobPosition() {
        return this.contactPersonJobPosition;
    }

    public void setContactPersonJobPosition(String contactPersonJobPosition) {
        this.contactPersonJobPosition = contactPersonJobPosition;
    }

    public String getContactPersonEmail() {
        return this.contactPersonEmail;
    }

    public void setContactPersonEmail(String contactPersonEmail) {
        this.contactPersonEmail = contactPersonEmail;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Vendor getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(Vendor salesRep) {
        this.salesRep = salesRep;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public Floor getFloor() {
        return this.floor;
    }

    public void setFloor(Floor floor) {
        this.floor = floor;
    }

    public Units getUnit() {
        return this.unit;
    }

    public void setUnit(Units unit) {
        this.unit = unit;
    }

    public String getKinName() {
        return this.kinName;
    }

    public void setKinName(String kinName) {
        this.kinName = kinName;
    }

    public String getKinIdNo() {
        return this.kinIdNo;
    }

    public void setKinIdNo(String kinIdNo) {
        this.kinIdNo = kinIdNo;
    }

    public String getKinPhoneNo() {
        return this.kinPhoneNo;
    }

    public void setKinPhoneNo(String kinPhoneNo) {
        this.kinPhoneNo = kinPhoneNo;
    }

    public String getKinRelationship() {
        return this.kinRelationship;
    }

    public void setKinRelationship(String kinRelationship) {
        this.kinRelationship = kinRelationship;
    }

    public String getEntryDate() {
        return this.entryDate;
    }

    public void setEntryDate(String entryDate) {
        this.entryDate = entryDate;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public double getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(double creditLimit) {
        this.creditLimit = creditLimit;
    }

    public double getCreditPeriod() {
        return this.creditPeriod;
    }

    public void setCreditPeriod(double creditPeriod) {
        this.creditPeriod = creditPeriod;
    }

    public PricingGroup getPricingGroup() {
        return this.pricingGroup;
    }

    public void setPricingGroup(PricingGroup pricingGroup) {
        this.pricingGroup = pricingGroup;
    }

    public String getDmsNo() {
        return this.dmsNo;
    }

    public void setDmsNo(String dmsNo) {
        this.dmsNo = dmsNo;
    }

    public ObservableList<Customer> getAllCustomers(User user) {
        ObservableList allCustomers = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=customer", params, user);
            Gson g = new Gson();
            Object[] response2 = (Customer[])g.fromJson(response, Customer[].class);
            allCustomers = FXCollections.observableArrayList((Object[])response2);
        }
        catch (Exception y) {
            y.printStackTrace();
        }
        return allCustomers;
    }

    public ObservableList<Customer> getAllCustomers(Map<String, Object> params, User user) {
        ObservableList allCustomers = FXCollections.observableArrayList();
        try {
            String response = Config.loadDataFromPhp("masterfetch?type=customer", params, user);
            Gson g = new Gson();
            Object[] response2 = (Customer[])g.fromJson(response, Customer[].class);
            allCustomers = FXCollections.observableArrayList((Object[])response2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allCustomers;
    }

    public String toString() {
        return this.getCustomerName();
    }

    public JsonResponses deleteCustomer(String customerNumber, User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("customerNumber", customerNumber);
            String response = Config.loadDataFromPhp("masterdelete?type=customer", params, user);
            Gson g = new Gson();
            return (JsonResponses)g.fromJson(response, JsonResponses.class);
        }
        catch (Exception e) {
            JsonResponses jr = new JsonResponses();
            jr.setStatus(false);
            jr.setMessage("We encountered an error while processing your request. Please try again later");
            return jr;
        }
    }

    public void getAllCustomersReport(User user) {
        Platform.runLater(() -> {
            try {
                Gson g = new Gson();
                String response3 = g.toJson(this.getAllCustomers(user));
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                parameters2.put("reportTitle", "All Customers");
                new Config().getReportWithJson("All Customers List", response3, "allcustomers.jasper", parameters2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void getCustomersWithBalanceReport(User user) {
        Platform.runLater(() -> {
            try {
                Gson g = new Gson();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("balance", 1);
                String response3 = g.toJson(this.getAllCustomers(params, user));
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                parameters2.put("reportTitle", "Customers With Balances");
                new Config().getReportWithJson("Customers With Balances", response3, "allcustomers.jasper", parameters2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public double getLatestBalance(User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("customerNo", this.getCustomerNumber());
            String response = Config.loadDataFromPhp("masterfetch?type=customer_balance", params, user);
            Double[] balances = (Double[])new Gson().fromJson(response, Double[].class);
            return balances[0];
        }
        catch (Exception ignored) {
            return 0.0;
        }
    }
}

