/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.Floor;
import classes.JsonResponses;
import classes.PaymentMethod;
import classes.Property;
import classes.Units;
import classes.User;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class CustomerReceipt {
    private String receiptNo;
    private Customer customer;
    private String paymentDate;
    private PaymentMethod paymentMethod;
    private String receivedFrom;
    private double amount;
    private Bank bank;
    private String externalRef;
    private boolean posted;
    private boolean reversed;
    private String paymentDescription;
    private String createdOn;
    private Property property;
    private Floor floor;
    private Units unit;

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.property = property;
    }

    public Floor getFloor() {
        return this.floor;
    }

    public void setFloor(Floor floor) {
        this.floor = floor;
    }

    public Units getUnits() {
        return this.unit;
    }

    public void setUnits(Units unit) {
        this.unit = unit;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public String getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getReceivedFrom() {
        return this.receivedFrom;
    }

    public void setReceivedFrom(String receivedFrom) {
        this.receivedFrom = receivedFrom;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public String getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(String externalRef) {
        this.externalRef = externalRef;
    }

    public String getPaymentDescription() {
        return this.paymentDescription;
    }

    public void setPaymentDescription(String paymentDescription) {
        this.paymentDescription = paymentDescription;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getAmountString() {
        return Config.formatNumber(this.amount);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public void showReceipt(CustomerReceipt receipt) {
        try {
            Gson g = new Gson();
            String json = g.toJson((Object)receipt);
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            new Config().getReportWithJson("Customer Receipt", json, "customerreceipt.jasper", parameters2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printReceipt(CustomerReceipt receipt) {
        try {
            Gson g = new Gson();
            String json = g.toJson((Object)receipt);
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            new Config().printReportWithJson("Customer Receipt", json, "customerreceipt.jasper", parameters2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ObservableList<CustomerReceipt> getAllReceipts(boolean posted, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted ? 1 : 0);
        String response = Config.loadDataFromPhp("masterfetch?type=customerreceipts", params, user);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, CustomerReceipt[].class)));
    }

    public JsonResponses deleteReceipt(String receiptNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("receiptNo", receiptNo);
        String response = Config.loadDataFromPhp("masterdelete?type=customerreceipt", params, user);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses postReceipt(String receiptNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("receiptNo", receiptNo);
        String response = Config.loadDataFromPhp("masterpost?type=customerreceipt", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses voidReceipt(String receiptNo, User user, int bouncedCheque) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("receiptNo", receiptNo);
        params.put("bouncedCheque", bouncedCheque);
        String response = Config.loadDataFromPhp("masterpost?type=reverse_customer_receipt", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }
}

