/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Module;
import classes.SubModule;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class DashboardMatrix {
    private int id;
    private Module module;
    private SubModule submodule;
    private boolean view;
    private User user;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public SubModule getSubmodule() {
        return this.submodule;
    }

    public void setSubmodule(SubModule submodule) {
        this.submodule = submodule;
    }

    public boolean isView() {
        return this.view;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CheckBox getCanView() {
        CheckBox myCheck = new CheckBox();
        myCheck.setSelected(this.isView());
        myCheck.setOnAction(e -> {
            int canView = myCheck.isSelected() ? 1 : 0;
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("matrixId", this.getId());
            params.put("view", canView);
            String response = Config.loadDataFromPhp("mastercreate?type=dashboardmatrix", params, this.getUser());
        });
        return myCheck;
    }

    public ObservableList<DashboardMatrix> getMatrix(User user, int roleId) {
        ObservableList matrix = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("roleId", roleId);
        String response = Config.loadDataFromPhp("masterfetch?type=dashboardmatrix", params, user);
        System.out.println(response);
        matrix = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, DashboardMatrix[].class)));
        for (DashboardMatrix myMatrix : matrix) {
            myMatrix.setUser(user);
            toReturn.add((Object)myMatrix);
        }
        return toReturn;
    }

    public ObservableList<DashboardMatrix> getMatrix(User user, int roleId, int moduleId) {
        ObservableList matrix = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("roleId", roleId);
        params.put("moduleId", moduleId);
        String response = Config.loadDataFromPhp("masterfetch?type=dashboardmatrix", params, user);
        matrix = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, DashboardMatrix[].class)));
        for (DashboardMatrix myMatrix : matrix) {
            myMatrix.setUser(user);
            toReturn.add((Object)myMatrix);
        }
        return toReturn;
    }
}

