/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.DataRights;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class DataRightsMatrix {
    private int id;
    private int roleId;
    private DataRights dataRight;
    private boolean insert;
    private boolean view;
    private boolean update;
    private boolean delete;
    private boolean post;
    private boolean reverse;
    private User user;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public DataRights getDataRight() {
        return this.dataRight;
    }

    public void setDataRight(DataRights dataRight) {
        this.dataRight = dataRight;
    }

    public boolean isInsert() {
        return this.insert;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    public boolean isView() {
        return this.view;
    }

    public void setView(boolean view) {
        this.view = view;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isPost() {
        return this.post;
    }

    public void setPost(boolean post) {
        this.post = post;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public CheckBox getInsertCheck() {
        if (this.getDataRight().isHasInsert()) {
            CheckBox myCheck = new CheckBox();
            myCheck.setSelected(this.isInsert());
            myCheck.setOnAction(e -> {
                int canInsert = myCheck.isSelected() ? 1 : 0;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("matrixId", this.getId());
                params.put("action", "insert");
                params.put("value", canInsert);
                String response = Config.loadDataFromPhp("mastercreate?type=datarightsmatrix", params, this.getUser());
            });
            return myCheck;
        }
        return null;
    }

    public CheckBox getViewCheck() {
        if (this.getDataRight().isHasView()) {
            CheckBox myCheck = new CheckBox();
            myCheck.setSelected(this.isView());
            myCheck.setOnAction(e -> {
                int canInsert = myCheck.isSelected() ? 1 : 0;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("matrixId", this.getId());
                params.put("action", "view");
                params.put("value", canInsert);
                String response = Config.loadDataFromPhp("mastercreate?type=datarightsmatrix", params, this.getUser());
            });
            return myCheck;
        }
        return null;
    }

    public CheckBox getUpdateCheck() {
        if (this.getDataRight().isHasUpdate()) {
            CheckBox myCheck = new CheckBox();
            myCheck.setSelected(this.isUpdate());
            myCheck.setOnAction(e -> {
                int canInsert = myCheck.isSelected() ? 1 : 0;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("matrixId", this.getId());
                params.put("action", "update");
                params.put("value", canInsert);
                String response = Config.loadDataFromPhp("mastercreate?type=datarightsmatrix", params, this.getUser());
            });
            return myCheck;
        }
        return null;
    }

    public CheckBox getDeleteCheck() {
        if (this.getDataRight().isHasDelete()) {
            CheckBox myCheck = new CheckBox();
            myCheck.setSelected(this.isDelete());
            myCheck.setOnAction(e -> {
                int canInsert = myCheck.isSelected() ? 1 : 0;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("matrixId", this.getId());
                params.put("action", "delete");
                params.put("value", canInsert);
                String response = Config.loadDataFromPhp("mastercreate?type=datarightsmatrix", params, this.getUser());
                System.out.println(response);
            });
            return myCheck;
        }
        return null;
    }

    public CheckBox getPostCheck() {
        if (this.getDataRight().isHasPost()) {
            CheckBox myCheck = new CheckBox();
            myCheck.setSelected(this.isPost());
            myCheck.setOnAction(e -> {
                int canInsert = myCheck.isSelected() ? 1 : 0;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("matrixId", this.getId());
                params.put("action", "post");
                params.put("value", canInsert);
                String response = Config.loadDataFromPhp("mastercreate?type=datarightsmatrix", params, this.getUser());
                System.out.println(response);
            });
            return myCheck;
        }
        return null;
    }

    public CheckBox getReverseCheck() {
        if (this.getDataRight().isHasReverse()) {
            CheckBox myCheck = new CheckBox();
            myCheck.setSelected(this.isReverse());
            myCheck.setOnAction(e -> {
                int canInsert = myCheck.isSelected() ? 1 : 0;
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("matrixId", this.getId());
                params.put("action", "reverse");
                params.put("value", canInsert);
                String response = Config.loadDataFromPhp("mastercreate?type=datarightsmatrix", params, this.getUser());
                System.out.println(response);
            });
            return myCheck;
        }
        return null;
    }

    public ObservableList<DataRightsMatrix> getMatrix(int moduleId, int roleId, User user) {
        ObservableList matrix = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("moduleId", moduleId);
        params.put("roleId", roleId);
        String response = Config.loadDataFromPhp("masterfetch?type=datarightsmatrix", params, user);
        matrix = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, DataRightsMatrix[].class)));
        for (DataRightsMatrix myMatrix : matrix) {
            myMatrix.setUser(user);
            toReturn.add((Object)myMatrix);
        }
        return toReturn;
    }
}

