/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.UUID;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import net.sf.jasperreports.engine.JasperCompileManager;

public class DynamicReports {
    private String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<jasperReport xmlns=\"http://jasperreports.sourceforge.net/jasperreports\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://jasperreports.sourceforge.net/jasperreports http://jasperreports.sourceforge.net/xsd/jasperreport.xsd\" name=\"Blank_A4\" pageWidth=\"842\" pageHeight=\"595\" orientation=\"Landscape\" columnWidth=\"802\" leftMargin=\"20\" rightMargin=\"20\" topMargin=\"20\" bottomMargin=\"20\" uuid=\"cd5a12c3-a383-44f4-b44e-d4fadffb71ff\"><parameter name=\"reportName\" class=\"java.lang.String\"/>\n\t<parameter name=\"saccoName\" class=\"java.lang.String\"/>";
    private String titleText = "<title>\n<band height=\"126\">\n<image>\n<reportElement x=\"2\" y=\"-6\" width=\"156\" height=\"86\" uuid=\"8e7470e5-34ca-48ae-91ad-7d3c73b5b68a\"/>\n\t\t\t\t<imageExpression><![CDATA[\"logo.jpg\"]]></imageExpression>\n\t\t\t</image>\n\t\t\t<textField>\n\t\t\t\t<reportElement x=\"160\" y=\"-6\" width=\"643\" height=\"86\" forecolor=\"#F3A0A8\" uuid=\"83fc140e-ec8d-4036-9db0-1f1e24d15b1e\"/>\n\t\t\t\t<textElement textAlignment=\"Center\">\n\t\t\t\t\t<font fontName=\"Serif\" size=\"22\"/>\n\t\t\t\t</textElement>\n\t\t\t\t<textFieldExpression><![CDATA[$P{saccoName}]]></textFieldExpression>\n\t\t\t</textField>\n\t\t\t<line>\n\t\t\t\t<reportElement x=\"0\" y=\"82\" width=\"802\" height=\"1\" forecolor=\"#FF9999\" uuid=\"07bfbe9b-f282-4412-8217-96aa5b8e0604\">\n\t\t\t\t\t<property name=\"com.jaspersoft.studio.unit.x\" value=\"px\"/>\n\t\t\t\t\t<property name=\"com.jaspersoft.studio.unit.width\" value=\"px\"/>\n\t\t\t\t</reportElement>\n\t\t\t</line>\n\t\t\t<line>\n\t\t\t\t<reportElement x=\"0\" y=\"84\" width=\"802\" height=\"1\" forecolor=\"#99CCCC\" uuid=\"05c299f7-e254-4521-929f-cf5eb12d5c9a\">\n\t\t\t\t\t<property name=\"com.jaspersoft.studio.unit.height\" value=\"px\"/>\n\t\t\t\t\t<property name=\"com.jaspersoft.studio.unit.x\" value=\"px\"/>\n\t\t\t\t\t<property name=\"com.jaspersoft.studio.unit.width\" value=\"px\"/>\n\t\t\t\t</reportElement>\n\t\t\t</line>\n\t\t\t<textField>\n\t\t\t\t<reportElement x=\"0\" y=\"88\" width=\"802\" height=\"30\" uuid=\"8dfe7896-645b-44ba-a9fe-a086a7157e91\"/>\n\t\t\t\t<textElement textAlignment=\"Center\">\n\t\t\t\t\t<font fontName=\"Serif\" size=\"16\" isBold=\"true\"/>\n\t\t\t\t</textElement>\n\t\t\t\t<textFieldExpression><![CDATA[$P{reportName}]]></textFieldExpression>\n\t\t\t</textField>\n\t\t</band>\n\t</title>";
    private String footer = "</jasperReport>";
    private String columnHeaderBandHeader = "<columnHeader><band height=\"20\" splitType=\"Stretch\">";
    private String columnHeaderBandFooter = "</band></columnHeader>";
    private String detailBandHeader = "<detail><band height=\"15\" splitType=\"Stretch\"><property name=\"com.jaspersoft.studio.unit.height\" value=\"px\"/>";
    private String detailBandFooter = "</band></detail>";
    private String pageFooterText = "<pageFooter><band height=\"20\" splitType=\"Stretch\">\n<textField><reportElement x=\"370\" y=\"0\" width=\"100\" height=\"20\" uuid=\"f596c1aa-f0ed-41f2-bc36-9a52ffc77969\"/><textElement textAlignment=\"Right\"/><textFieldExpression><![CDATA[\"Page \" + $V{PAGE_NUMBER}]]></textFieldExpression></textField><textField evaluationTime=\"Report\"><reportElement x=\"470\" y=\"0\" width=\"100\" height=\"20\" uuid=\"bcbf9cc1-b39b-4bcf-a8fa-cabd0b87f292\"/><textElement textAlignment=\"Left\"/><textFieldExpression><![CDATA[\" of \" + $V{PAGE_NUMBER}]]></textFieldExpression></textField></band></pageFooter>";
    private String pageSummaryHeader = "<summary><band height=\"30\" splitType=\"Stretch\">";
    private String pageSummaryFooter = "</band></summary>";
    private ObservableList<DynamicReportFields> allFields;

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public ObservableList<DynamicReportFields> getAllFields() {
        return this.allFields;
    }

    public String getColumnHeaderBandHeader() {
        return this.columnHeaderBandHeader;
    }

    public void setColumnHeaderBandHeader(String columnHeaderBandHeader) {
        this.columnHeaderBandHeader = columnHeaderBandHeader;
    }

    public String getColumnHeaderBandFooter() {
        return this.columnHeaderBandFooter;
    }

    public void setColumnHeaderBandFooter(String columnHeaderBandFooter) {
        this.columnHeaderBandFooter = columnHeaderBandFooter;
    }

    public String getDetailBandHeader() {
        return this.detailBandHeader;
    }

    public void setDetailBandHeader(String detailBandHeader) {
        this.detailBandHeader = detailBandHeader;
    }

    public String getDetailBandFooter() {
        return this.detailBandFooter;
    }

    public void setDetailBandFooter(String detailBandFooter) {
        this.detailBandFooter = detailBandFooter;
    }

    public String getPageFooterText() {
        return this.pageFooterText;
    }

    public void setPageFooterText(String pageFooterText) {
        this.pageFooterText = pageFooterText;
    }

    public String getPageSummaryHeader() {
        return this.pageSummaryHeader;
    }

    public void setPageSummaryHeader(String pageSummaryHeader) {
        this.pageSummaryHeader = pageSummaryHeader;
    }

    public String getPageSummaryFooter() {
        return this.pageSummaryFooter;
    }

    public void setPageSummaryFooter(String pageSummaryFooter) {
        this.pageSummaryFooter = pageSummaryFooter;
    }

    public void setAllFields(ObservableList<DynamicReportFields> allFields) {
        this.allFields = allFields;
    }

    public void addField(DynamicReportFields field) {
        try {
            this.getAllFields().add((Object)field);
        }
        catch (NullPointerException y) {
            ObservableList mine = FXCollections.observableArrayList();
            mine.add((Object)field);
            this.setAllFields((ObservableList<DynamicReportFields>)mine);
        }
    }

    public JsonResponses generateReport(String reportName) {
        JsonResponses jr = new JsonResponses();
        jr.setStatus(false);
        jr.setMessage("The report could not be generated");
        try {
            String reportText = "";
            reportText = reportText + this.getHeader();
            String fieldsText = "";
            String variablesText = "";
            String columnHeaderText = "";
            String detailBandText = "";
            String summaryBandText = "";
            int xAxis = 0;
            try {
                for (DynamicReportFields field : this.getAllFields()) {
                    int width = field.getWidth();
                    String pattern = "";
                    if (field.getDataType().equalsIgnoreCase("java.lang.Double")) {
                        pattern = "pattern=\"#,##0.###;(#,##0.###-)\"";
                    }
                    fieldsText = fieldsText + "<field name=\"" + field.getColumnName() + "\" class=\"" + field.getDataType() + "\"/>";
                    columnHeaderText = columnHeaderText + "<staticText><reportElement x=\"" + xAxis + "\" y=\"0\" width=\"" + width + "\" height=\"20\" uuid=\"" + this.getUUID(field.getColumnName() + "Header") + "\"/><box><pen lineWidth=\"0.25\"/></box><textElement textAlignment=\"Center\"><font fontName=\"Serif\" isBold=\"true\"/></textElement><text><![CDATA[" + field.getColumnTitle() + "]]></text></staticText>";
                    detailBandText = detailBandText + "<textField isBlankWhenNull=\"true\" " + pattern + "><reportElement x=\"" + xAxis + "\" y=\"0\" width=\"" + width + "\" height=\"15\" uuid=\"e48a1091-d6ea-470e-a8e9-c4fddff98873\"><property name=\"com.jaspersoft.studio.spreadsheet.connectionID\" value=\"22ef323b-363c-4c47-a399-2fbb597a46cd\"/>\n<property name=\"com.jaspersoft.studio.unit.height\" value=\"px\"/></reportElement><box leftPadding=\"3\"><pen lineWidth=\"0.25\"/></box><textElement textAlignment=\"Left\"><font fontName=\"Serif\" size=\"9\"/></textElement><textFieldExpression><![CDATA[$F{" + field.getColumnName() + "}]]></textFieldExpression></textField>";
                    if (field.showTotal) {
                        variablesText = variablesText + "<variable name=\"" + field.getColumnName() + "1\" class=\"" + field.getDataType() + "\" resetType=\"Report\" calculation=\"Sum\">\n<variableExpression><![CDATA[$F{" + field.getColumnName() + "}]]></variableExpression>\n</variable>";
                        summaryBandText = summaryBandText + "<textField isBlankWhenNull=\"true\" " + pattern + "><reportElement x=\"" + xAxis + "\" y=\"0\" width=\"" + width + "\" height=\"30\" uuid=\"" + this.getUUID(field.getColumnName() + "summary") + "\"/>\n<box leftPadding=\"3\"><pen lineWidth=\"0.25\"/></box><textElement textAlignment=\"Left\"/><textFieldExpression><![CDATA[$V{" + field.getColumnName() + "1}]]></textFieldExpression></textField>";
                    }
                    xAxis += width;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            reportText = reportText + fieldsText;
            reportText = reportText + variablesText;
            reportText = reportText + this.titleText;
            reportText = reportText + this.getColumnHeaderBandHeader();
            reportText = reportText + columnHeaderText;
            reportText = reportText + this.getColumnHeaderBandFooter();
            reportText = reportText + this.getDetailBandHeader();
            reportText = reportText + detailBandText;
            reportText = reportText + this.getDetailBandFooter();
            reportText = reportText + this.getPageFooterText();
            reportText = reportText + this.getPageSummaryHeader();
            reportText = reportText + summaryBandText;
            reportText = reportText + this.getPageSummaryFooter();
            reportText = reportText + this.getFooter();
            String path = Config.getReportURL() + reportName + ".jrxml";
            Files.write(Paths.get(path, new String[0]), reportText.getBytes(), new OpenOption[0]);
            JasperCompileManager.compileReportToFile((String)path, (String)(Config.getReportURL() + reportName + ".jasper"));
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return jr;
    }

    public String getUUID(String string) {
        try {
            byte[] bytes = string.getBytes("UTF-8");
            UUID uuid = UUID.nameUUIDFromBytes(bytes);
            return uuid.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public class DynamicReportFields {
        private String columnTitle;
        private String columnName;
        private String dataType;
        private int width;
        private boolean showTotal;

        public DynamicReportFields() {
        }

        public DynamicReportFields(String columnTitle, String columnName, String dataType, int width, boolean showTotal) {
            this.showTotal = showTotal;
            this.width = width;
            this.dataType = dataType;
            this.columnName = columnName;
            this.columnTitle = columnTitle;
        }

        public String getColumnTitle() {
            return this.columnTitle;
        }

        public void setColumnTitle(String columnTitle) {
            this.columnTitle = columnTitle;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public boolean isShowTotal() {
            return this.showTotal;
        }

        public void setShowTotal(boolean showTotal) {
            this.showTotal = showTotal;
        }
    }
}

