/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class ExpressSaleLine {
    private User user;
    private int id;
    private int quantity;
    private ShopItem item;
    private String saleCode;
    private double unitPrice;
    private double totalExclVAT;
    private double totalVAT;
    private double totalAmount;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String getItem() {
        return this.item.getName();
    }

    public void setItem(ShopItem item) {
        this.item = item;
    }

    public String getSaleCode() {
        return this.saleCode;
    }

    public void setSaleCode(String saleCode) {
        this.saleCode = saleCode;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public String getUnitPriceString() {
        return Config.formatNumber(this.unitPrice);
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public double getTotalExclVAT() {
        return this.totalExclVAT;
    }

    public void setTotalExclVAT(double totalExclVAT) {
        this.totalExclVAT = totalExclVAT;
    }

    public double getTotalVAT() {
        return this.totalVAT;
    }

    public void setTotalVAT(double totalVAT) {
        this.totalVAT = totalVAT;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTotal() {
        new Config();
        return Config.formatNumber(this.unitPrice * (double)this.quantity);
    }

    public Button getRemove() {
        Button deleteBtn = new Button();
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        deleteBtn.setGraphic((Node)icon);
        deleteBtn.setOnAction(event -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", this.id);
            params.put("saleCode", this.saleCode);
            new Config();
            String response = Config.loadDataFromPhp("masterdelete?type=expresssaleline", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                // empty if block
            }
        });
        return deleteBtn;
    }

    public String toString() {
        return "ExpressSaleLine{id=" + this.id + ", quantity=" + this.quantity + ", item='" + this.item + '\'' + ", saleCode='" + this.saleCode + '\'' + ", unitPrice=" + this.unitPrice + '}';
    }

    public ObservableList<ExpressSaleLine> getAllLines(String saleCode, User user) {
        ObservableList allLines = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("saleCode", saleCode);
            String response = Config.loadDataFromPhp("masterfetch?type=expresssaleline", params, user);
            Gson g = new Gson();
            allLines = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, ExpressSaleLine[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ExpressSaleLine line : allLines) {
            line.setUser(user);
            toReturn.add((Object)line);
        }
        return toReturn;
    }
}

