/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Account;
import classes.Config;
import classes.Employee;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class FixedAssets {
    public String assetNo;
    private String assetName;
    public String Description;
    public String assetSerial;
    public String dateAcquired;
    public double bookValue;
    public Employee assignedTo;
    public String location;
    private Account acquisitionGLAccount;
    private Account appreciationGLAccount;

    public String getAssetNo() {
        return this.assetNo;
    }

    public void setAssetNo(String assetNo) {
        this.assetNo = assetNo;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public String getAssetSerial() {
        return this.assetSerial;
    }

    public void setAssetSerial(String assetSerial) {
        this.assetSerial = assetSerial;
    }

    public String getDateAcquired() {
        return this.dateAcquired;
    }

    public void setDateAcquired(String dateAcquired) {
        this.dateAcquired = dateAcquired;
    }

    public double getBookValue() {
        return this.bookValue;
    }

    public void setBookValue(double bookValue) {
        this.bookValue = bookValue;
    }

    public Employee getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(Employee assignedTo) {
        this.assignedTo = assignedTo;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public void setAssetName(String assetName) {
        this.assetName = assetName;
    }

    public Account getAcquisitionGLAccount() {
        return this.acquisitionGLAccount;
    }

    public void setAcquisitionGLAccount(Account acquisitionGLAccount) {
        this.acquisitionGLAccount = acquisitionGLAccount;
    }

    public Account getAppreciationGLAccount() {
        return this.appreciationGLAccount;
    }

    public void setAppreciationGLAccount(Account appreciationGLAccount) {
        this.appreciationGLAccount = appreciationGLAccount;
    }

    public String getBookValueString() {
        return Config.formatNumber(this.bookValue);
    }

    public String getAssetPhoto(User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("faNo", this.getAssetNo());
        String response = Config.loadDataFromPhp("masterfetch?type=assetimage", params, user);
        String[] myImage = (String[])new Gson().fromJson(response, String[].class);
        return myImage[0];
    }

    public ObservableList<FixedAssets> getAllAssets(User user) {
        ObservableList allAssets = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String response = Config.loadDataFromPhp("masterfetch?type=fixedasset", params, user);
        System.out.println(response);
        Gson g = new Gson();
        Object[] fixedAssets = (FixedAssets[])g.fromJson(response, FixedAssets[].class);
        allAssets = FXCollections.observableArrayList((Object[])fixedAssets);
        return allAssets;
    }

    public ObservableList<FixedAssets> getAllAssets(boolean vehicle, User user) {
        ObservableList allAssets = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vehicle", vehicle ? 1 : 0);
        String response = Config.loadDataFromPhp("masterfetch?type=fixedasset", params, user);
        Gson g = new Gson();
        Object[] fixedAssets = (FixedAssets[])g.fromJson(response, FixedAssets[].class);
        allAssets = FXCollections.observableArrayList((Object[])fixedAssets);
        return allAssets;
    }

    public String toString() {
        return this.assetName;
    }
}

