/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Loan;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class InterestLine {
    private int lineNo;
    private String headerNo;
    private Loan loan;
    private double interest;
    private boolean posted;

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getHeaderNo() {
        return this.headerNo;
    }

    public void setHeaderNo(String headerNo) {
        this.headerNo = headerNo;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    public double getInterest() {
        return this.interest;
    }

    public void setInterest(double interest) {
        this.interest = interest;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public ObservableList<InterestLine> getAllLines(String voucherNo, User user) {
        ObservableList allLines = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("voucherNo", voucherNo);
        String response = Config.loadDataFromPhp("masterfetch?type=interestline", params, user);
        allLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, InterestLine[].class)));
        return allLines;
    }

    public String getInterestString() {
        return Config.formatNumber(this.interest);
    }

    public String getLoanNo() {
        return this.loan.getLoanNumber();
    }

    public String getMemberNo() {
        return this.loan.getMember().getMemberNumber();
    }

    public String getMemberName() {
        return this.loan.getMember().getFullName();
    }

    public String getLoanProduct() {
        return this.loan.getLoanProduct().getLoanProductName();
    }

    public String getAmountIssued() {
        return Config.formatNumber(this.loan.getLoanAmount());
    }

    public String getLoanBalance() {
        return Config.formatNumber(this.loan.getLoanBalance());
    }
}

