/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.LoanDisbursementMethods;
import classes.LoanLines;
import classes.LoanProduct;
import classes.Member;
import classes.User;
import com.google.gson.Gson;
import controllers.LoanCardController;
import filterscontrollers.AllLoansStatement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Hyperlink;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class Loan {
    private User user;
    private String loanNumber;
    private Member member;
    private LoanProduct loanProduct;
    private double loanAmount;
    private int loanInstallments;
    private LoanDisbursementMethods loanDisbursementMode;
    private Bank payingBank;
    private String checkNumber;
    private boolean issued;
    private String issuedOn;
    private String status;
    private String lastPaymentDate;
    private String phoneNumber;
    private String ApplicationDate;
    private String loanAmountString;
    private double loanBalance;
    private String loanBalanceString;
    private double crbCharge;
    private double chequeCommission;
    private double insurance;
    private double loanForm;
    private Bank chargesReceivingBank;
    private String chargesExternalDocNo;
    private double monthlyRepayment;
    private boolean loanTopUp;
    private String loanTopUpNo;
    ArrayList<LoanLines> lines;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ArrayList<LoanLines> getLines() {
        return this.lines;
    }

    public void setLines(ArrayList<LoanLines> lines) {
        this.lines = lines;
    }

    public double getLoanBalance() {
        return this.loanBalance;
    }

    public void setLoanBalance(double loanBalance) {
        this.loanBalance = loanBalance;
    }

    public String getLoanBalanceString() {
        return Config.formatNumber(this.loanBalance);
    }

    public void setLoanBalanceString(String loanBalanceString) {
        this.loanBalanceString = loanBalanceString;
    }

    public String getLoanAmountString() {
        return Config.formatNumber(this.loanAmount);
    }

    public void setLoanAmountString(String loanAmountString) {
        this.loanAmountString = loanAmountString;
    }

    public String getApplicationDate() {
        return this.ApplicationDate;
    }

    public void setApplicationDate(String applicationDate) {
        this.ApplicationDate = applicationDate;
    }

    public String getPhoneNumber() {
        return this.member.getPhoneNumber();
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Loan(String loanNumber, Member member, LoanProduct loanProduct, double loanAmount, int loanInstallments, LoanDisbursementMethods loanDisbursementMode, Bank payingBank, String checkNumber, boolean issued, String issuedOn, String status, String lastPaymentDate, String ApplicationDate) {
        this.loanNumber = loanNumber;
        this.member = member;
        this.loanProduct = loanProduct;
        this.loanAmount = loanAmount;
        this.loanInstallments = loanInstallments;
        this.loanDisbursementMode = loanDisbursementMode;
        this.payingBank = payingBank;
        this.checkNumber = checkNumber;
        this.issued = issued;
        this.issuedOn = issuedOn;
        this.status = status;
        this.lastPaymentDate = lastPaymentDate;
        this.ApplicationDate = ApplicationDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLastPaymentDate() {
        return this.lastPaymentDate;
    }

    public void setLastPaymentDate(String lastPaymentDate) {
        this.lastPaymentDate = lastPaymentDate;
    }

    public Loan() {
    }

    public String getLoanNumber() {
        return this.loanNumber;
    }

    public void setLoanNumber(String loanNumber) {
        this.loanNumber = loanNumber;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public LoanProduct getLoanProduct() {
        return this.loanProduct;
    }

    public void setLoanProduct(LoanProduct loanProduct) {
        this.loanProduct = loanProduct;
    }

    public double getLoanAmount() {
        return this.loanAmount;
    }

    public void setLoanAmount(double loanAmount) {
        this.loanAmount = loanAmount;
    }

    public int getLoanInstallments() {
        return this.loanInstallments;
    }

    public void setLoanInstallments(int loanInstallments) {
        this.loanInstallments = loanInstallments;
    }

    public LoanDisbursementMethods getLoanDisbursementMode() {
        return this.loanDisbursementMode;
    }

    public void setLoanDisbursementMode(LoanDisbursementMethods loanDisbursementMode) {
        this.loanDisbursementMode = loanDisbursementMode;
    }

    public Bank getPayingBank() {
        return this.payingBank;
    }

    public void setPayingBank(Bank payingBank) {
        this.payingBank = payingBank;
    }

    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public boolean isIssued() {
        return this.issued;
    }

    public void setIssued(boolean issued) {
        this.issued = issued;
    }

    public String getIssuedOn() {
        return this.issuedOn;
    }

    public void setIssuedOn(String issuedOn) {
        this.issuedOn = issuedOn;
    }

    public double getCrbCharge() {
        return this.crbCharge;
    }

    public void setCrbCharge(double crbCharge) {
        this.crbCharge = crbCharge;
    }

    public double getChequeCommission() {
        return this.chequeCommission;
    }

    public void setChequeCommission(double chequeCommission) {
        this.chequeCommission = chequeCommission;
    }

    public double getInsurance() {
        return this.insurance;
    }

    public void setInsurance(double insurance) {
        this.insurance = insurance;
    }

    public double getLoanForm() {
        return this.loanForm;
    }

    public void setLoanForm(double loanForm) {
        this.loanForm = loanForm;
    }

    public Bank getChargesReceivingBank() {
        return this.chargesReceivingBank;
    }

    public void setChargesReceivingBank(Bank chargesReceivingBank) {
        this.chargesReceivingBank = chargesReceivingBank;
    }

    public String getChargesExternalDocNo() {
        return this.chargesExternalDocNo;
    }

    public void setChargesExternalDocNo(String chargesExternalDocNo) {
        this.chargesExternalDocNo = chargesExternalDocNo;
    }

    public double getMonthlyRepayment() {
        return this.monthlyRepayment;
    }

    public void setMonthlyRepayment(double monthlyRepayment) {
        this.monthlyRepayment = monthlyRepayment;
    }

    public boolean isLoanTopUp() {
        return this.loanTopUp;
    }

    public void setLoanTopUp(boolean loanTopUp) {
        this.loanTopUp = loanTopUp;
    }

    public String getLoanTopUpNo() {
        return this.loanTopUpNo;
    }

    public void setLoanTopUpNo(String loanTopUpNo) {
        this.loanTopUpNo = loanTopUpNo;
    }

    public ObservableList<Loan> getAllLoans(Map<String, Object> params, User user) {
        ObservableList allLoans = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            String response2 = Config.loadDataFromPhp("masterfetch?type=loans", params, user);
            Gson g = new Gson();
            Object[] memberFromJson = (Loan[])g.fromJson(response2, Loan[].class);
            allLoans = FXCollections.observableArrayList((Object[])memberFromJson);
            for (Loan loan : allLoans) {
                loan.setUser(user);
                toReturn.add((Object)loan);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return toReturn;
    }

    public ObservableList<Loan> getAllLoans(boolean isIssued, String memberNumber, User user) {
        ObservableList allLoans = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("issued", isIssued);
            params.put("memberNumber", memberNumber);
            String response = Config.loadDataFromPhp("masterfetch?type=loans", params, user);
            Gson g = new Gson();
            Object[] loansFromJson = (Loan[])g.fromJson(response, Loan[].class);
            allLoans = FXCollections.observableArrayList((Object[])loansFromJson);
            for (Loan loan : allLoans) {
                loan.setUser(user);
                toReturn.add((Object)loan);
            }
        }
        catch (Exception r) {
            r.printStackTrace();
        }
        return allLoans;
    }

    public Hyperlink getLoanLink() {
        Hyperlink link = new Hyperlink(this.getLoanNumber());
        link.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/loancard.fxml").openStream());
                LoanCardController controller = (LoanCardController)loader.getController();
                controller.setUser(this.getUser());
                controller.setLoan(this);
                Scene addItemScene = new Scene((Parent)itemPane, 912.0, 508.0);
                Stage stage = new Stage();
                stage.setScene(addItemScene);
                stage.setTitle("Edit loan application");
                stage.setResizable(false);
                stage.showAndWait();
            }
            catch (Exception p) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your edit loan screen. Please contact support");
                p.printStackTrace();
                alert.showAndWait();
            }
        });
        return link;
    }

    public String toString() {
        return this.loanNumber + " - " + Config.formatNumber(this.loanAmount);
    }

    public void generateAllLoansStatement(User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/allloansstatement.fxml").openStream());
            AllLoansStatement controller = (AllLoansStatement)loader.getController();
            controller.setUser(user);
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            stage.setTitle("All loans statement");
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }
}

