/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import controllers.EditNumberSeries;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class NumberSeries {
    private User user;
    private int code;
    private String name;
    private String prefix;
    private int length;
    private String lastNumberUsed;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Button getEdit() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.PENCIL);
        icon.setStyle("-fx-fill: #4CAF50;");
        icon.setSize("16.0");
        Button editButton = new Button();
        editButton.setGraphic((Node)icon);
        editButton.setOnAction(e -> this.editNumberSeries());
        return editButton;
    }

    public void setEdit(Button edit) {
        edit.setText("Edit");
        edit.setOnAction(e -> {});
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getLastNumberUsed() {
        return this.lastNumberUsed;
    }

    public void setLastNumberUsed(String lastNumberUsed) {
        this.lastNumberUsed = lastNumberUsed;
    }

    public NumberSeries() {
    }

    public NumberSeries(int code, User user) {
        try {
            this.setUser(user);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("code", code);
            String response = Config.loadDataFromPhp("masterfetch?type=numberseries", params, user);
            Gson g = new Gson();
            NumberSeries[] nb = (NumberSeries[])g.fromJson(response, NumberSeries[].class);
            this.code = nb[0].code;
            this.name = nb[0].name;
            this.prefix = nb[0].prefix;
            this.length = nb[0].length;
            this.lastNumberUsed = nb[0].lastNumberUsed;
        }
        catch (Exception t) {
            t.printStackTrace();
        }
    }

    public String getNextNumber() {
        String nextNumber = "";
        String lastCodeUsed = this.lastNumberUsed.replace(this.prefix, "");
        int lastCode = Integer.parseInt(lastCodeUsed);
        int newCode = lastCode + 1;
        int lengthDifference = this.length - (this.prefix + newCode).length();
        nextNumber = this.prefix;
        if (lengthDifference > 0) {
            for (int a = 0; a < lengthDifference; ++a) {
                nextNumber = nextNumber + "0";
            }
        }
        nextNumber = nextNumber + newCode;
        return nextNumber;
    }

    public void editNumberSeries() {
        NumberSeries nb = new NumberSeries(this.getCode(), this.getUser());
        EditNumberSeries ns = new EditNumberSeries(nb);
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/editNumberSeries.fxml"));
            loader.setController((Object)ns);
            AnchorPane editLayout = (AnchorPane)loader.load();
            Scene scene = new Scene((Parent)editLayout, 513.0, 257.0);
            Stage stage = new Stage();
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.setResizable(false);
            stage.setTitle("Edit Number Series");
            stage.setScene(scene);
            stage.showAndWait();
        }
        catch (Exception y) {
            y.printStackTrace();
        }
    }

    public void updateLastUsed(String lastNumberUsed) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("code", this.getCode());
            params.put("lastNumber", lastNumberUsed);
            Config.loadDataFromPhp("masterupdate?type=numberserieslastnumber", params, this.getUser());
        }
        catch (Exception e) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while connecting to the database. Please try again later. ");
            alert.showAndWait();
        }
    }

    public ObservableList<NumberSeries> getAllNumberSeries(User user) {
        ObservableList allNumberSeries = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=numberseries", params, user);
            Gson g = new Gson();
            allNumberSeries = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, NumberSeries[].class)));
            for (NumberSeries myNumberSeries : allNumberSeries) {
                myNumberSeries.setUser(user);
                toReturn.add((Object)myNumberSeries);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return toReturn;
    }
}

