/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PaymentMethod {
    private int code;
    private String paymentMethod;
    private boolean requiresRef;
    private boolean pdc;

    public PaymentMethod(int code, String paymentMethod, boolean requiresRef) {
        this.code = code;
        this.paymentMethod = paymentMethod;
        this.requiresRef = requiresRef;
    }

    public PaymentMethod() {
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public boolean isRequiresRef() {
        return this.requiresRef;
    }

    public boolean isPdc() {
        return this.pdc;
    }

    public void setPdc(boolean pdc) {
        this.pdc = pdc;
    }

    public void setRequiresRef(boolean requiresRef) {
        this.requiresRef = requiresRef;
    }

    public ObservableList<PaymentMethod> getAllPaymentMethods(User user) {
        ObservableList allPaymentMethods = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=paymentmethod", params, user);
            Gson g = new Gson();
            Object[] myMethods = (PaymentMethod[])g.fromJson(response, PaymentMethod[].class);
            allPaymentMethods = FXCollections.observableArrayList((Object[])myMethods);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allPaymentMethods;
    }

    public String toString() {
        return this.getPaymentMethod();
    }
}

