/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Loan;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class PenaltyLine {
    private int lineNo;
    private String headerNo;
    private Loan loan;
    private double penalty;
    private boolean posted;
    private boolean exempt;

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getHeaderNo() {
        return this.headerNo;
    }

    public void setHeaderNo(String headerNo) {
        this.headerNo = headerNo;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    public double getPenalty() {
        return this.penalty;
    }

    public void setPenalty(double penalty) {
        this.penalty = penalty;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public boolean isExempt() {
        return this.exempt;
    }

    public void setExempt(boolean exempt) {
        this.exempt = exempt;
    }

    public ObservableList<PenaltyLine> getAllLines(String voucherNo, User user) {
        ObservableList allLines = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("voucherNo", voucherNo);
        String response = Config.loadDataFromPhp("masterfetch?type=penaltyline", params, user);
        allLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, PenaltyLine[].class)));
        return allLines;
    }

    public String getPenaltyString() {
        return Config.formatNumber(this.penalty);
    }

    public String getLoanNo() {
        return this.loan.getLoanNumber();
    }

    public String getMemberNo() {
        return this.loan.getMember().getMemberNumber();
    }

    public String getMemberName() {
        return this.loan.getMember().getFullName();
    }

    public String getLoanProduct() {
        return this.loan.getLoanProduct().getLoanProductName();
    }

    public String getAmountIssued() {
        return Config.formatNumber(this.loan.getLoanAmount());
    }

    public String getLoanBalance() {
        return Config.formatNumber(this.loan.getLoanBalance());
    }

    public CheckBox getExemptCheckbox() {
        CheckBox box = new CheckBox();
        box.setSelected(this.isExempt());
        box.setDisable(this.isPosted());
        box.setOnAction(e -> this.setExempt(box.isSelected()));
        return box;
    }
}

