/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.Region;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PettyCashVoucher {
    private String pcvNo;
    private Bank bank;
    private boolean posted;
    private String createdOn;
    private String createdBy;
    private String postedOn;
    private String postedBy;
    private double totalPosted;
    private double total;
    private String refNo;
    private String pcvDate;
    private boolean reversed;
    private String reversedBy;
    private String reversedOn;
    private Region region;
    private Vendor salesRep;
    private String payee;

    public String getRefNo() {
        return this.refNo;
    }

    public void setRefNo(String refNo) {
        this.refNo = refNo;
    }

    public String getPcvNo() {
        return this.pcvNo;
    }

    public void setPcvNo(String pcvNo) {
        this.pcvNo = pcvNo;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getPostedOn() {
        return this.postedOn;
    }

    public void setPostedOn(String postedOn) {
        this.postedOn = postedOn;
    }

    public String getPostedBy() {
        return this.postedBy;
    }

    public void setPostedBy(String postedBy) {
        this.postedBy = postedBy;
    }

    public double getTotalPosted() {
        return this.totalPosted;
    }

    public void setTotalPosted(double totalPosted) {
        this.totalPosted = totalPosted;
    }

    public String getPcvDate() {
        return this.pcvDate;
    }

    public void setPcvDate(String pcvDate) {
        this.pcvDate = pcvDate;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public String getTotalString() {
        return Config.formatNumber(this.total);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public String getReversedBy() {
        return this.reversedBy;
    }

    public void setReversedBy(String reversedBy) {
        this.reversedBy = reversedBy;
    }

    public String getReversedOn() {
        return this.reversedOn;
    }

    public void setReversedOn(String reversedOn) {
        this.reversedOn = reversedOn;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public Vendor getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(Vendor salesRep) {
        this.salesRep = salesRep;
    }

    public String getPayee() {
        return this.payee;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public ObservableList<PettyCashVoucher> getAllVouchers(Boolean posted, Boolean reversed, User user) {
        ObservableList allVouchers = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted != false ? 1 : 0);
        params.put("reversed", reversed != false ? 1 : 0);
        String response = Config.loadDataFromPhp("masterfetch?type=pettycashvouchers", params, user);
        Gson g = new Gson();
        Object[] myPCV = (PettyCashVoucher[])g.fromJson(response, PettyCashVoucher[].class);
        allVouchers = FXCollections.observableArrayList((Object[])myPCV);
        return allVouchers;
    }

    public JsonResponses deleteVoucher(String voucherNo, User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("voucherNo", voucherNo);
            String response = Config.loadDataFromPhp("masterdelete?type=pettycashvouchers", params, user);
            Gson g = new Gson();
            return (JsonResponses)g.fromJson(response, JsonResponses.class);
        }
        catch (Exception r) {
            JsonResponses jr = new JsonResponses();
            jr.setMessage("We encountered an error while processing your request. Please try again");
            jr.setStatus(false);
            return jr;
        }
    }
}

