/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Account;
import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class ProfitNLossLines {
    private Account glAccount;
    private boolean include;

    public Account getGlAccount() {
        return this.glAccount;
    }

    public void setGlAccount(Account glAccount) {
        this.glAccount = glAccount;
    }

    public boolean isInclude() {
        return this.include;
    }

    public void setInclude(boolean include) {
        this.include = include;
    }

    public ObservableList<ProfitNLossLines> getAllLines(User user) {
        ObservableList<Account> allAccounts = Account.getAccounts(user);
        ObservableList myEntries = FXCollections.observableArrayList();
        for (Account myAccount : allAccounts) {
            ProfitNLossLines line = new ProfitNLossLines();
            line.glAccount = myAccount;
            line.include = false;
            myEntries.add((Object)line);
        }
        return myEntries;
    }

    public ObservableList<ProfitNLossLines> getAllLines(int code, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("code", code);
        String response = Config.loadDataFromPhp("masterfetch?type=profitnlosslines", params, user);
        ObservableList myEntries = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, ProfitNLossLines[].class)));
        return myEntries;
    }

    public CheckBox getIncludeCheck() {
        CheckBox check = new CheckBox();
        check.setSelected(this.isInclude());
        check.setOnAction(e -> this.setInclude(check.isSelected()));
        return check;
    }
}

