/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.Loan;
import classes.TransactionTypes;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import controllers.ReceiptController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class ReceiptLine {
    private User user;
    int lineNo;
    Loan loan;
    Vehicle vehicle;
    private TransactionTypes transactionType;
    private double amount;
    private String myName;
    private String formattedAmount;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getMyName() {
        return "victor";
    }

    public void setMyName(String myName) {
        this.myName = myName;
    }

    public ReceiptLine() {
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public TransactionTypes getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionTypes transactionType) {
        this.transactionType = transactionType;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getFormattedAmount() {
        return Config.formatNumber(this.amount);
    }

    public void setFormattedAmount(String formattedAmount) {
        this.formattedAmount = formattedAmount;
    }

    public Button getEdit() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.PENCIL);
        icon.setStyle("-fx-fill: #4CAF50;");
        icon.setSize("16.0");
        Button editButton = new Button();
        editButton.setGraphic((Node)icon);
        editButton.setOnAction(e -> {});
        return editButton;
    }

    public Button getDelete() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("receiptLine", this.getLineNo());
                String response = Config.loadDataFromPhp("masterdelete?type=receiptline", params, this.getUser());
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                System.out.println(response);
                if (jr.isStatus()) {
                    ObservableList<ReceiptLine> allLines = new ReceiptLine().getAllReceiptLines(jr.getMessage(), this.getUser());
                    double total = 0.0;
                    for (ReceiptLine line : allLines) {
                        total += line.amount;
                    }
                    ReceiptController.myAmount.setText(Config.formatNumber(total));
                    ReceiptController.myLines.setItems(allLines);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        return deleteButton;
    }

    public ReceiptLine(int lineNo, TransactionTypes transactionType, double amount, Loan myLoan) {
        this.lineNo = lineNo;
        this.transactionType = transactionType;
        this.amount = amount;
        this.loan = myLoan;
    }

    public ObservableList<ReceiptLine> getAllReceiptLines(String receiptNo, User user) {
        ObservableList allReceiptLines = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("receiptNo", receiptNo);
            String response = Config.loadDataFromPhp("masterfetch?type=receiptlines", params, user);
            Gson g = new Gson();
            allReceiptLines = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, ReceiptLine[].class)));
            for (ReceiptLine myLine : allReceiptLines) {
                myLine.setUser(user);
                toReturn.add((Object)myLine);
            }
        }
        catch (Exception y) {
            y.printStackTrace();
        }
        return toReturn;
    }
}

