/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public class ServiceFeeEntries {
    private int id;
    private int voucherNo;
    private Vehicle vehicle;
    private double daysInActive;
    private double feeCharged;
    private String feeChargedString;
    private boolean voucherposted;

    public boolean isVoucherposted() {
        return this.voucherposted;
    }

    public void setVoucherposted(boolean voucherposted) {
        this.voucherposted = voucherposted;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVoucherNo() {
        return this.voucherNo;
    }

    public void setVoucherNo(int voucherNo) {
        this.voucherNo = voucherNo;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public double getDaysInActive() {
        return this.daysInActive;
    }

    public void setDaysInActive(double daysInActive) {
        this.daysInActive = daysInActive;
    }

    public double getFeeCharged() {
        return this.feeCharged;
    }

    public void setFeeCharged(double feeCharged) {
        this.feeCharged = feeCharged;
    }

    public String getFeeChargedString() {
        return Config.formatNumber(this.feeCharged);
    }

    public Member getOwner() {
        return this.vehicle.getOwner();
    }

    public void setFeeChargedString(String feeChargedString) {
        this.feeChargedString = feeChargedString;
    }

    public TextField getEdit() {
        TextField textField = new TextField();
        textField.setDisable(this.isVoucherposted());
        textField.setPromptText("Inactive Days");
        textField.setText(this.getDaysInActive() + "");
        textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
        textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
            if (!arg2.booleanValue()) {
                try {
                    this.setDaysInActive(Double.parseDouble(textField.getText().trim()));
                }
                catch (NumberFormatException y) {
                    this.setDaysInActive(0.0);
                }
            }
        });
        return textField;
    }

    public ObservableList<ServiceFeeEntries> getAllEntries(int voucherNo, User user) {
        ObservableList allEntries = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("voucherNo", voucherNo);
        String response = Config.loadDataFromPhp("masterfetch?type=servicefeeentries", params, user);
        Gson g = new Gson();
        allEntries = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, ServiceFeeEntries[].class)));
        return allEntries;
    }

    public JsonResponses post(int voucherNo, User user) {
        JsonResponses jr = new JsonResponses();
        jr.setMessage("The Service Charge could not be posted");
        jr.setStatus(false);
        Gson g = new Gson();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("voucherNo", voucherNo);
        String response = Config.loadDataFromPhp("masterpost?type=servicecharge", params, user);
        System.out.println(response);
        jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }
}

