/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.ItemBrand;
import classes.PostingGroup;
import classes.PricingGroup;
import classes.ShopLocation;
import classes.TaxGroup;
import classes.UnitOfMeasure;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import controllers.ItemEntriesController;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class ShopItem {
    private String code;
    private String name;
    private String description;
    private String upcCode;
    private String photoBlob;
    private String classificationCode;
    private String dmsNo;
    private double discount;
    private double price;
    private double buyingPrice;
    private TaxGroup taxGroup;
    private ItemBrand brand;
    private UnitOfMeasure unitOfMeasure;
    private PostingGroup postingGroup;
    private ShopLocation location;
    private double available;
    private String photoUrl;
    private double reOrderLevel;
    private User user;

    public String getClassificationCode() {
        return this.classificationCode;
    }

    public void setClassificationCode(String classificationCode) {
        this.classificationCode = classificationCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getPrice() {
        return this.price;
    }

    public String getPriceString() {
        return Config.formatNumber(this.price);
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public String getUpcCode() {
        return this.upcCode;
    }

    public void setUpcCode(String upcCode) {
        this.upcCode = upcCode;
    }

    public TaxGroup getTaxGroup() {
        return this.taxGroup;
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        this.taxGroup = taxGroup;
    }

    public ItemBrand getBrand() {
        return this.brand;
    }

    public void setBrand(ItemBrand brand) {
        this.brand = brand;
    }

    public UnitOfMeasure getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public PostingGroup getPostingGroup() {
        return this.postingGroup;
    }

    public void setPostingGroup(PostingGroup postingGroup) {
        this.postingGroup = postingGroup;
    }

    public void setUnitOfMeasure(UnitOfMeasure unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getPhotoBlob() {
        return this.photoBlob;
    }

    public void setPhotoBlob(String photoBlob) {
        this.photoBlob = photoBlob;
    }

    public ShopLocation getLocation() {
        return this.location;
    }

    public void setLocation(ShopLocation location) {
        this.location = location;
    }

    public double getAvailable() {
        return this.available;
    }

    public void setAvailable(double available) {
        this.available = available;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public double getReOrderLevel() {
        return this.reOrderLevel;
    }

    public void setReOrderLevel(double reOrderLevel) {
        this.reOrderLevel = reOrderLevel;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public double getBuyingPrice() {
        return this.buyingPrice;
    }

    public String getBuyingPriceString() {
        return Config.formatNumber(this.buyingPrice);
    }

    public void setBuyingPrice(double buyingPrice) {
        this.buyingPrice = buyingPrice;
    }

    public String getDmsNo() {
        return this.dmsNo;
    }

    public void setDmsNo(String dmsNo) {
        this.dmsNo = dmsNo;
    }

    public Hyperlink getBalanceHyperlink() {
        Hyperlink link = new Hyperlink();
        link.setText(Config.formatNumber(this.getAvailable()));
        link.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                final Stage stage = new Stage();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/itementries.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                ItemEntriesController controller = (ItemEntriesController)loader.getController();
                controller.setUser(this.user);
                controller.setSelectedItem(this);
                stage.setTitle("View Item Entries");
                stage.showAndWait();
            }
            catch (Exception p) {
                GeneralListController.publicNotificationPane.setText("We encountered an error while loading the item entries. Please try again");
                GeneralListController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
                GeneralListController.publicNotificationPane.show();
            }
        });
        return link;
    }

    public String toString() {
        return this.name;
    }

    public ObservableList<ShopItem> getAllItems(User user) {
        new Config();
        return FXCollections.observableList(Arrays.asList((Object[])new Gson().fromJson(Config.loadDataFromPhp("masterfetch?type=item", new LinkedHashMap<String, Object>(), user), ShopItem[].class)));
    }

    public ObservableList<ShopItem> getAllItems(HashMap<String, Object> params, User user) {
        new Config();
        return FXCollections.observableList(Arrays.asList((Object[])new Gson().fromJson(Config.loadDataFromPhp("masterfetch?type=item", params, user), ShopItem[].class)));
    }

    public ObservableList<PricingGroup.PricingGroupEntries> getPrices(String productCode, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("productCode", productCode);
        String response = Config.loadDataFromPhp("masterfetch?type=product_prices", params, user);
        ObservableList allPrices = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, PricingGroup.PricingGroupEntries[].class)));
        return allPrices;
    }

    public ObservableList<ItemClassification> getAllClassification(User user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        new Config();
        String response = Config.loadDataFromPhp("masterfetch?type=item_classification", params, user);
        Object[] countries = (ItemClassification[])new Gson().fromJson(response, ItemClassification[].class);
        return FXCollections.observableArrayList((Object[])countries);
    }

    public ObservableList<ItemType> getItemTypes(User user) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        new Config();
        String response = Config.loadDataFromPhp("masterfetch?type=item_types", params, user);
        Object[] countries = (ItemType[])new Gson().fromJson(response, ItemType[].class);
        return FXCollections.observableArrayList((Object[])countries);
    }

    public static class ItemType {
        String code;
        String name;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public class ItemClassification {
        private String code;
        private String name;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

