/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.ShopItem;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class StockTake {
    private String docNo;
    private String date;
    private String createdOn;
    private String createdBy;
    private ShopLocation warehouse;
    private boolean closed;
    private double totalDiscrepancy;

    public String getDocNo() {
        return this.docNo;
    }

    public void setDocNo(String docNo) {
        this.docNo = docNo;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public ShopLocation getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(ShopLocation warehouse) {
        this.warehouse = warehouse;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public double getTotalDiscrepancy() {
        return this.totalDiscrepancy;
    }

    public String getTotalDiscrepancyString() {
        return Config.formatNumber(this.totalDiscrepancy);
    }

    public void setTotalDiscrepancy(double totalDiscrepancy) {
        this.totalDiscrepancy = totalDiscrepancy;
    }

    public ObservableList<StockTakeLines> getLines(String docNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", docNo);
        String response = Config.loadDataFromPhp("masterfetch?type=stock_take_lines", params, user);
        return FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, StockTakeLines[].class)));
    }

    public class StockTakeLines {
        private int lineId;
        private String headerNo;
        private String itemCode;
        private ShopItem item;
        private double physicalCount;
        private double availableStock;
        private double variance;
        private double unitPrice;
        private double totalValue;

        public int getLineId() {
            return this.lineId;
        }

        public void setLineId(int lineId) {
            this.lineId = lineId;
        }

        public String getHeaderNo() {
            return this.headerNo;
        }

        public void setHeaderNo(String headerNo) {
            this.headerNo = headerNo;
        }

        public ShopItem getItem() {
            return this.item;
        }

        public void setItem(ShopItem item) {
            this.item = item;
        }

        public double getPhysicalCount() {
            return this.physicalCount;
        }

        public void setPhysicalCount(double physicalCount) {
            this.physicalCount = physicalCount;
        }

        public double getAvailableStock() {
            return this.availableStock;
        }

        public void setAvailableStock(double availableStock) {
            this.availableStock = availableStock;
        }

        public double getVariance() {
            return this.variance;
        }

        public void setVariance(double variance) {
            this.variance = variance;
        }

        public double getUnitPrice() {
            return this.unitPrice;
        }

        public void setUnitPrice(double unitPrice) {
            this.unitPrice = unitPrice;
        }

        public double getTotalValue() {
            return this.totalValue;
        }

        public void setTotalValue(double totalValue) {
            this.totalValue = totalValue;
        }

        public String getItemCode() {
            return this.itemCode;
        }

        public void setItemCode(String itemCode) {
            this.itemCode = itemCode;
        }
    }
}

