/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import controllers.ParkingFeeController;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBox;

public class Town {
    private int townId;
    private String townName;
    private Vendor county;
    private double countyParkingFee;
    private double saccoParkingFee;
    private boolean selected;

    public int getTownId() {
        return this.townId;
    }

    public void setTownId(int townId) {
        this.townId = townId;
    }

    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public Vendor getCounty() {
        return this.county;
    }

    public void setCounty(Vendor county) {
        this.county = county;
    }

    public double getCountyParkingFee() {
        return this.countyParkingFee;
    }

    public String getCountyParkingFeeString() {
        return Config.formatNumber(this.countyParkingFee);
    }

    public void setCountyParkingFee(double countyParkingFee) {
        this.countyParkingFee = countyParkingFee;
    }

    public double getSaccoParkingFee() {
        return this.saccoParkingFee;
    }

    public String getSaccoParkingFeeString() {
        return Config.formatNumber(this.saccoParkingFee);
    }

    public void setSaccoParkingFee(double saccoParkingFee) {
        this.saccoParkingFee = saccoParkingFee;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return this.getTownName();
    }

    public ObservableList<Town> getAllTowns(User user) {
        ObservableList allTowns = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String response = Config.loadDataFromPhp("masterfetch?type=towns", params, user);
        Gson g = new Gson();
        allTowns = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, Town[].class)));
        return allTowns;
    }

    public CheckBox getCheckbox() {
        CheckBox checkbox = new CheckBox();
        checkbox.setSelected(this.isSelected());
        checkbox.setOnAction(e -> {
            this.setSelected(checkbox.isSelected());
            try {
                ObservableList myTowns = ParkingFeeController.publicTowns.getItems();
                double total = 0.0;
                for (Town town : myTowns) {
                    if (!town.isSelected()) continue;
                    total += town.getSaccoParkingFee();
                }
                ParkingFeeController.publicAmount.setText(Config.formatNumber(total));
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
        return checkbox;
    }
}

