/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Account;
import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TransactionTypes {
    private String transactionTypeCode;
    private String transactionTypeDescription;
    private Account glAccount;
    private String addedOn;
    private String addedBy;
    private int noOfTransactions;
    private boolean enabled;
    private String accountName;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public TransactionTypes(String transactionTypeCode) {
        this.transactionTypeCode = transactionTypeCode;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public TransactionTypes(String transactionTypeCode, String transactionTypeDescription, Account glAccount, String addedOn, String addedBy, boolean enabled) {
        this.transactionTypeCode = transactionTypeCode;
        this.transactionTypeDescription = transactionTypeDescription;
        this.glAccount = glAccount;
        this.addedOn = addedOn;
        this.addedBy = addedBy;
        this.enabled = enabled;
    }

    public String getTransactionTypeCode() {
        return this.transactionTypeCode;
    }

    public void setTransactionTypeCode(String transactionTypeCode) {
        this.transactionTypeCode = transactionTypeCode;
    }

    public String getTransactionTypeDescription() {
        return this.transactionTypeDescription;
    }

    public void setTransactionTypeDescription(String transactionTypeDescription) {
        this.transactionTypeDescription = transactionTypeDescription;
    }

    public Account getGlAccount() {
        return this.glAccount;
    }

    public void setGlAccount(Account glAccount) {
        this.glAccount = glAccount;
        this.accountName = glAccount.getAccountName();
    }

    public String getAddedOn() {
        return this.addedOn;
    }

    public void setAddedOn(String addedOn) {
        this.addedOn = addedOn;
    }

    public String getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(String addedBy) {
        this.addedBy = addedBy;
    }

    public int getNoOfTransactions() {
        return this.noOfTransactions;
    }

    public void setNoOfTransactions(int noOfTransactions) {
        this.noOfTransactions = noOfTransactions;
    }

    public TransactionTypes() {
    }

    public ObservableList<TransactionTypes> getTransactionTypes(int type, User user) {
        ObservableList allTransactionTypes = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("type", type);
        String response = Config.loadDataFromPhp("masterfetch?type=transactiontypes", params, user);
        Gson g = new Gson();
        Object[] response2 = (TransactionTypes[])g.fromJson(response, TransactionTypes[].class);
        allTransactionTypes = FXCollections.observableArrayList((Object[])response2);
        return allTransactionTypes;
    }

    public ObservableList<TransactionTypes> getTransactionTypesPerAccountType(String accountType, User user) {
        ObservableList allTransactionTypes = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("accountType", accountType);
        String response = Config.loadDataFromPhp("masterfetch?type=transactiontypes", params, user);
        System.out.println(response);
        Gson g = new Gson();
        Object[] response2 = (TransactionTypes[])g.fromJson(response, TransactionTypes[].class);
        allTransactionTypes = FXCollections.observableArrayList((Object[])response2);
        return allTransactionTypes;
    }

    public String toString() {
        return this.getTransactionTypeDescription();
    }
}

