/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.util.Map;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyFloatWrapper;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;

public class TreeMapValueFactory<T>
implements Callback<TreeTableColumn.CellDataFeatures<Map, T>, ObservableValue<T>> {
    private Object key;

    public TreeMapValueFactory(Object key) {
        this.key = key;
    }

    public ObservableValue<T> call(TreeTableColumn.CellDataFeatures<Map, T> cdf) {
        Map map = (Map)cdf.getValue().getValue();
        Object value = map.get(this.key);
        if (value instanceof ObservableValue) {
            return (ObservableValue)value;
        }
        if (value instanceof Boolean) {
            return new ReadOnlyBooleanWrapper(((Boolean)value).booleanValue());
        }
        if (value instanceof Integer) {
            return new ReadOnlyIntegerWrapper(((Integer)value).intValue());
        }
        if (value instanceof Float) {
            return new ReadOnlyFloatWrapper(((Float)value).floatValue());
        }
        if (value instanceof Long) {
            return new ReadOnlyLongWrapper(((Long)value).longValue());
        }
        if (value instanceof Double) {
            return new ReadOnlyDoubleWrapper(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new ReadOnlyStringWrapper((String)value);
        }
        return new ReadOnlyObjectWrapper(value);
    }
}

