/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Floor;
import classes.UnitTypes;
import classes.User;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Units {
    private int unitId;
    private String unitCode;
    private String propertyCode;
    private Floor floor;
    private UnitTypes unitType;
    private double monthlyRent;
    private String size;

    public int getUnitId() {
        return this.unitId;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getPropertyCode() {
        return this.propertyCode;
    }

    public void setPropertyCode(String propertyCode) {
        this.propertyCode = propertyCode;
    }

    public Floor getFloor() {
        return this.floor;
    }

    public void setFloor(Floor floor) {
        this.floor = floor;
    }

    public UnitTypes getUnitType() {
        return this.unitType;
    }

    public void setUnitType(UnitTypes unitType) {
        this.unitType = unitType;
    }

    public double getMonthlyRent() {
        return this.monthlyRent;
    }

    public String getMonthlyRentString() {
        return Config.formatNumber(this.monthlyRent);
    }

    public void setMonthlyRent(double monthlyRent) {
        this.monthlyRent = monthlyRent;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public ObservableList<Units> getAllUnits(String propertyCode, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("propertyCode", propertyCode);
        return FXCollections.observableList(Arrays.asList((Object[])new Gson().fromJson(Config.loadDataFromPhp("masterfetch?type=unit", params, user), Units[].class)));
    }

    public ObservableList<Units> getFloorUnits(String propertyCode, String floorId, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("propertyCode", propertyCode);
        params.put("floorId", floorId);
        return FXCollections.observableList(Arrays.asList((Object[])new Gson().fromJson(Config.loadDataFromPhp("masterfetch?type=floorunit", params, user), Units[].class)));
    }

    public String toString() {
        return this.unitCode;
    }
}

