/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Member;
import classes.User;
import classes.VehicleBrands;
import classes.VehicleMakes;
import classes.VehicleModels;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Vehicle {
    private String regNo;
    private String fleetNumber;
    private String name;
    private Member owner;
    private VehicleMakes make;
    private VehicleModels model;
    private String photoBlob;
    private double serviceArrears;
    private String serviceArrearsString;
    private VehicleBrands brand;
    private boolean active;

    public String getPhotoBlob() {
        return this.photoBlob;
    }

    public void setPhotoBlob(String photoBlob) {
        this.photoBlob = photoBlob;
    }

    public Vehicle(String regNo, String fleetNumber, String name, Member owner, VehicleMakes make, VehicleModels model) {
        this.regNo = regNo;
        this.fleetNumber = fleetNumber;
        this.name = name;
        this.owner = owner;
        this.make = make;
        this.model = model;
    }

    public String getRegNo() {
        try {
            return this.regNo.substring(0, 3) + " " + this.regNo.substring(3, 6) + " " + this.regNo.substring(6, 7);
        }
        catch (Exception t) {
            return this.regNo;
        }
    }

    public void setRegNo(String regNo) {
        this.regNo = regNo;
    }

    public String getFleetNumber() {
        return this.fleetNumber;
    }

    public void setFleetNumber(String fleetNumber) {
        this.fleetNumber = fleetNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Member getOwner() {
        return this.owner;
    }

    public void setOwner(Member owner) {
        this.owner = owner;
    }

    public VehicleMakes getMake() {
        return this.make;
    }

    public void setMake(VehicleMakes make) {
        this.make = make;
    }

    public VehicleModels getModel() {
        return this.model;
    }

    public void setModel(VehicleModels model) {
        this.model = model;
    }

    public double getServiceArrears() {
        return this.serviceArrears;
    }

    public void setServiceArrears(double serviceArrears) {
        this.serviceArrears = serviceArrears;
    }

    public String getServiceArrearsString() {
        return Config.formatNumber(this.serviceArrears);
    }

    public void setServiceArrearsString(String serviceArrearsString) {
        this.serviceArrearsString = serviceArrearsString;
    }

    public Vehicle() {
    }

    public ObservableList<Vehicle> getAllVehicles(User user) {
        ObservableList allVehicles = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("active", 1);
            String response2 = Config.loadDataFromPhp("masterfetch?type=vehicles", params, user);
            Gson g = new Gson();
            Object[] vehiclesFromJson = (Vehicle[])g.fromJson(response2, Vehicle[].class);
            allVehicles = FXCollections.observableArrayList((Object[])vehiclesFromJson);
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return allVehicles;
    }

    public VehicleBrands getBrand() {
        return this.brand;
    }

    public void setBrand(VehicleBrands brand) {
        this.brand = brand;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ObservableList<Vehicle> getMemberVehicles(String memberNo, User user) {
        ObservableList allVehicles = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("memberNo", memberNo);
            String response2 = Config.loadDataFromPhp("masterfetch?type=vehicles", params, user);
            Gson g = new Gson();
            Object[] vehiclesFromJson = (Vehicle[])g.fromJson(response2, Vehicle[].class);
            allVehicles = FXCollections.observableArrayList((Object[])vehiclesFromJson);
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return allVehicles;
    }

    public String getVehicleOwnerName(String vehicleReg, User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("vehicleReg", vehicleReg);
            String response = Config.loadDataFromPhp("masterfetch?type=vehicleownername", params, user);
            String[] owner = (String[])new Gson().fromJson(response, String[].class);
            return owner[0];
        }
        catch (Exception u) {
            return "";
        }
    }

    public String toString() {
        return this.getRegNo();
    }
}

