/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.PostingGroup;
import classes.Region;
import classes.User;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Vendor {
    private String vendorNumber;
    private String name;
    private String vendorId;
    private String vendorPhone;
    private String vendorEmail;
    private String vendorAddress;
    private double balance;
    private String balanceString;
    private String kraPin;
    private String dateOfBirth;
    private PostingGroup vendorPostingGroup;
    private String contactPersonName;
    private String contactPersonPhone;
    private String contactPersonJobPosition;
    private String contactPersonEmail;
    private String bankName;
    private String bankBranch;
    private String branchCode;
    private String bankAccountNo;
    private String vendorImage;
    private Region region;
    private String remarks;

    public String getVendorNumber() {
        return this.vendorNumber;
    }

    public void setVendorNumber(String vendorNumber) {
        this.vendorNumber = vendorNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name;
    }

    public String getVendorName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBranchCode() {
        return this.branchCode;
    }

    public void setBranchCode(String branchCode) {
        this.branchCode = branchCode;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public String getVendorPhone() {
        return this.vendorPhone;
    }

    public void setVendorPhone(String vendorPhone) {
        this.vendorPhone = vendorPhone;
    }

    public String getVendorEmail() {
        return this.vendorEmail;
    }

    public void setVendorEmail(String vendorEmail) {
        this.vendorEmail = vendorEmail;
    }

    public String getVendorAddress() {
        return this.vendorAddress;
    }

    public void setVendorAddress(String vendorAddress) {
        this.vendorAddress = vendorAddress;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getBalanceString() {
        return Config.formatNumber(this.balance);
    }

    public void setBalanceString(String balanceString) {
        this.balanceString = balanceString;
    }

    public String getKraPin() {
        return this.kraPin;
    }

    public void setKraPin(String kraPin) {
        this.kraPin = kraPin;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PostingGroup getVendorPostingGroup() {
        return this.vendorPostingGroup;
    }

    public void setVendorPostingGroup(PostingGroup vendorPostingGroup) {
        this.vendorPostingGroup = vendorPostingGroup;
    }

    public String getContactPersonName() {
        return this.contactPersonName;
    }

    public void setContactPersonName(String contactPersonName) {
        this.contactPersonName = contactPersonName;
    }

    public String getContactPersonPhone() {
        return this.contactPersonPhone;
    }

    public void setContactPersonPhone(String contactPersonPhone) {
        this.contactPersonPhone = contactPersonPhone;
    }

    public String getContactPersonJobPosition() {
        return this.contactPersonJobPosition;
    }

    public void setContactPersonJobPosition(String contactPersonJobPosition) {
        this.contactPersonJobPosition = contactPersonJobPosition;
    }

    public String getContactPersonEmail() {
        return this.contactPersonEmail;
    }

    public void setContactPersonEmail(String contactPersonEmail) {
        this.contactPersonEmail = contactPersonEmail;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankBranch() {
        return this.bankBranch;
    }

    public void setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
    }

    public String getBankAccountNo() {
        return this.bankAccountNo;
    }

    public void setBankAccountNo(String bankAccountNo) {
        this.bankAccountNo = bankAccountNo;
    }

    public String getVendorImage() {
        return this.vendorImage;
    }

    public void setVendorImage(String vendorImage) {
        this.vendorImage = vendorImage;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public ObservableList<Vendor> getAllVendors(User user) {
        ObservableList allVendors = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=vendor", params, user);
            Gson g = new Gson();
            Object[] response2 = (Vendor[])g.fromJson(response, Vendor[].class);
            allVendors = FXCollections.observableArrayList((Object[])response2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allVendors;
    }

    public ObservableList<Vendor> getAllVendors(String vendorType, User user) {
        ObservableList allVendors = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("vendortype", vendorType);
            String response = Config.loadDataFromPhp("masterfetch?type=vendor", params, user);
            Gson g = new Gson();
            Object[] response2 = (Vendor[])g.fromJson(response, Vendor[].class);
            allVendors = FXCollections.observableArrayList((Object[])response2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allVendors;
    }

    public String toString() {
        return this.getName();
    }

    public JsonResponses deleteVendor(String vendorNumber, User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("vendorNumber", vendorNumber);
            String response = Config.loadDataFromPhp("masterdelete?type=vendor", params, user);
            Gson g = new Gson();
            return (JsonResponses)g.fromJson(response, JsonResponses.class);
        }
        catch (Exception e) {
            JsonResponses jr = new JsonResponses();
            jr.setStatus(false);
            jr.setMessage("We encountered an error while processing your request. Please try again later");
            return jr;
        }
    }

    public ObservableList<Vendor> getPropertyOwner(User user, String propertyCode) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("property", propertyCode);
        return FXCollections.observableList(Arrays.asList((Object[])new Gson().fromJson(Config.loadDataFromPhp("masterfetch?type=vendorproperty", params, user), Vendor[].class)));
    }
}

