/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Department;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.Property;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddEmployeeController
implements Initializable {
    private User user;
    private int caretaker;
    String imagePath = "";
    @FXML
    private ComboBox<Property> property;
    @FXML
    private VBox root;
    @FXML
    private VBox holder;
    @FXML
    private TextField firstName;
    @FXML
    private TextField middleName;
    @FXML
    private TextField lastName;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private TextField payrollNumber;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private DatePicker dateOfBirth;
    @FXML
    private TextField idNumber;
    @FXML
    private JFXButton addEmployee;
    @FXML
    private JFXButton reset;
    @FXML
    private TextField kraPin;
    @FXML
    private CheckBox disabled;
    @FXML
    private TextArea disabilityDescription;
    @FXML
    private TextField nssfNumber;
    @FXML
    private TextField nhifNumber;
    @FXML
    private TextField jobTitle;
    @FXML
    private CheckBox hod;
    @FXML
    private CheckBox entitledToLeave;
    @FXML
    private DatePicker employmentDate;
    @FXML
    private HBox disabilityDescriptionHbox;
    @FXML
    private ComboBox<String> gender;
    @FXML
    private ComboBox<Department> department;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Platform.runLater(() -> {
            this.department.setItems(new Department().getAllDepartments(this.getUser()));
            this.property.setItems(new Property().getAllProperties(this.getUser()));
        });
    }

    public int getCaretaker() {
        return this.caretaker;
    }

    public void setCaretaker(int caretaker) {
        this.caretaker = caretaker;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        this.disabilityDescriptionHbox.setVisible(false);
        this.disabilityDescriptionHbox.managedProperty().bind((ObservableValue)this.disabilityDescriptionHbox.visibleProperty());
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.firstName, Validator.createEmptyValidator((String)"First name is required"));
        validationSupport.registerValidator((Control)this.lastName, Validator.createEmptyValidator((String)"Last name is required"));
        validationSupport.registerValidator((Control)this.idNumber, Validator.createEmptyValidator((String)"Id number is required"));
        validationSupport.registerValidator((Control)this.phoneNumber, Validator.createEmptyValidator((String)"Phone number is required"));
        validationSupport.registerValidator(this.gender, Validator.createEmptyValidator((String)"Gender is required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ObservableList genderOptions = FXCollections.observableArrayList();
        genderOptions.add((Object)"Male");
        genderOptions.add((Object)"Female");
        this.gender.setItems(genderOptions);
        this.gender.getSelectionModel().select(0);
        this.addEmployee.setOnAction(e -> {
            LocalDate ldate;
            String fName = "";
            String lName = "";
            String mName = "";
            String tidNumber = "";
            String tphoneNumber = "";
            String tPayrollN = "";
            String email = "";
            String dob = "";
            String tEmploymentDate = "";
            boolean tDisabled = this.disabled.isSelected();
            boolean tEntitledToLeave = this.entitledToLeave.isSelected();
            String tdisabilityDescription = "";
            String tKra = "";
            String tNssf = "";
            String tNhif = "";
            String tGender = "";
            int tDepartment = 0;
            String tJobTitle = "";
            boolean tHod = this.hod.isSelected();
            boolean error = false;
            String message = "";
            String tProperty = "";
            try {
                fName = this.firstName.getText().trim();
                if (fName.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = "Please input the employee first name. ";
            }
            try {
                lName = this.lastName.getText().trim();
                if (lName.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input the employee last name. ";
            }
            try {
                tGender = ((String)this.gender.getValue()).trim();
                if (tGender.equals("")) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please select the employee gender. ";
            }
            try {
                tidNumber = this.idNumber.getText().trim();
                if (tidNumber.equals("")) {
                    throw new Exception();
                }
                try {
                    Integer.parseInt(tidNumber);
                }
                catch (Exception y) {
                    error = true;
                    message = message + (message.length() == 0 ? "" : "\n");
                    message = message + "Please input a valid id number. ";
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input a valid id number. ";
            }
            try {
                tphoneNumber = this.phoneNumber.getText().trim();
                if (tphoneNumber.equals("")) {
                    throw new Exception();
                }
                if (tphoneNumber.length() < 10 || tphoneNumber.length() > 13) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "Please input a valid phone number. ";
            }
            try {
                mName = this.middleName.getText().trim();
            }
            catch (Exception t) {
                mName = "";
            }
            try {
                tPayrollN = this.payrollNumber.getText().trim();
            }
            catch (Exception t) {
                tPayrollN = "";
            }
            try {
                email = this.emailAddress.getText().trim();
            }
            catch (Exception t) {
                email = "";
            }
            try {
                tdisabilityDescription = this.disabilityDescription.getText().trim();
            }
            catch (Exception t) {
                tdisabilityDescription = "";
            }
            try {
                tKra = this.kraPin.getText().trim();
            }
            catch (Exception t) {
                tKra = "";
            }
            try {
                tNhif = this.nhifNumber.getText().trim();
            }
            catch (Exception t) {
                tNhif = "";
            }
            try {
                tNssf = this.nssfNumber.getText().trim();
            }
            catch (Exception t) {
                tNssf = "";
            }
            try {
                tJobTitle = this.jobTitle.getText().trim();
            }
            catch (Exception t) {
                tJobTitle = "";
            }
            try {
                tDepartment = ((Department)this.department.getValue()).getCode();
            }
            catch (Exception t) {
                tDepartment = 0;
            }
            try {
                try {
                    ldate = (LocalDate)this.dateOfBirth.getValue();
                    dob = Config.localDateToString(ldate);
                }
                catch (NullPointerException r) {
                    dob = "0000-00-00";
                }
            }
            catch (Exception t) {
                dob = "0000-00-00";
            }
            try {
                try {
                    ldate = (LocalDate)this.employmentDate.getValue();
                    tEmploymentDate = Config.localDateToString(ldate);
                }
                catch (NullPointerException r) {
                    tEmploymentDate = "0000-00-00";
                }
            }
            catch (Exception t) {
                tEmploymentDate = "0000-00-00";
            }
            try {
                tProperty = ((Property)this.property.getValue()).getPropertyCode();
            }
            catch (Exception y) {
                tProperty = "0";
            }
            if (error) {
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.setText(message);
                this.notificationPane.show();
            } else {
                try {
                    this.notificationPane.setText("Please wait while we add the employee.........");
                    this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    this.notificationPane.show();
                    NumberSeries nb = new NumberSeries(5, this.getUser());
                    String employeeNumber = nb.getNextNumber();
                    ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                    String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("employeeNumber", employeeNumber);
                    params.put("fName", fName);
                    params.put("lName", lName);
                    params.put("mName", mName);
                    params.put("idNumber", tidNumber);
                    params.put("phoneNumber", tphoneNumber);
                    params.put("payrollNumber", tPayrollN);
                    params.put("email", email);
                    params.put("dob", dob);
                    params.put("gender", tGender);
                    params.put("disabled", tDisabled);
                    params.put("disabilityDescription", tdisabilityDescription);
                    params.put("kra", tKra);
                    params.put("nssf", tNssf);
                    params.put("nhif", tNhif);
                    params.put("department", tDepartment);
                    params.put("jobTitle", tJobTitle);
                    params.put("hod", tHod);
                    params.put("photo", photoJson);
                    params.put("employmentDate", tEmploymentDate);
                    params.put("entitledToLeave", tEntitledToLeave ? 1 : 0);
                    params.put("property", tProperty);
                    params.put("caretaker", this.getCaretaker());
                    String response = Config.loadDataFromPhp("mastercreate?type=employee", params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        nb.updateLastUsed(employeeNumber);
                        Stage stage = (Stage)this.addEmployee.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.show();
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while trying to add the employee. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                    y.printStackTrace();
                }
            }
        });
        this.disabled.setOnAction(e -> {
            if (this.disabled.isSelected()) {
                this.disabilityDescriptionHbox.setVisible(true);
            } else {
                this.disabilityDescriptionHbox.setVisible(false);
            }
        });
        this.employmentDate.setValue((Object)Config.getCurrentLocaldate());
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)AddEmployeeController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.profilePhoto.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

