/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.ExpressSale;
import classes.JsonResponses;
import classes.LineNumbersCellFactory;
import classes.NumberSeries;
import classes.PricingGroup;
import classes.SalesHeader;
import classes.SalesLines;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import controllers.EditSalesLineController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddExpressSale
implements Initializable {
    public static String DOCUMENT_TYPE = "ExpressSale";
    HashMap<String, Double> pricingEntries = new HashMap();
    boolean salePosted = false;
    private User user;
    ObservableList<ShopItem> allItems = FXCollections.observableArrayList();
    @FXML
    private VBox vbAddSale;
    @FXML
    private ComboBox<Customer> customer;
    @FXML
    private TextField buyerKraPin;
    @FXML
    private TextField amount;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelCode;
    @FXML
    private TextField productCode;
    @FXML
    private ComboBox<Bank> cbBank;
    @FXML
    private TextField tfExtDoc;
    @FXML
    private Button searchCustomer;
    @FXML
    private TextField customerName;
    @FXML
    private HBox priceLevelHBox;
    @FXML
    private ComboBox<PricingGroup> pricingGroup;
    @FXML
    private ComboBox<ShopItem> item;
    @FXML
    private TextField quantity;
    @FXML
    private TextField sellingPrice;
    @FXML
    private Button addLine;
    @FXML
    private Button searchProduct;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSave;
    @FXML
    private HBox addItemHBox;
    @FXML
    private HBox addPaymentHBox;
    @FXML
    private Button btnPost;
    @FXML
    private Button btnReverse;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private Label totalLabel;
    @FXML
    private Label totalQuantity;
    @FXML
    private Label receiptTotal;
    @FXML
    private TableView<SalesLines> tvLines;
    @FXML
    private TableColumn rowCount;
    @FXML
    private TableColumn tcItem;
    @FXML
    private TableColumn tcPrice;
    @FXML
    private TableColumn tcQuantity;
    @FXML
    private TableColumn tcTotal;
    @FXML
    private TableColumn tcRemove;
    @FXML
    private NotificationPane notificationPane;
    private SalesHeader sale;
    private Gson g;
    @FXML
    private Button addPayment;
    @FXML
    private TableView<ExpressSale.ExpressSalePayments> allPayments;
    @FXML
    private TableColumn colPaymentMethod;
    @FXML
    private TableColumn colPaymentAmount;
    @FXML
    private TableColumn colTransactionCode;
    @FXML
    private TableColumn colRemovePayment;
    @FXML
    private Hyperlink balance;
    @FXML
    private Hyperlink change;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadItems();
        this.LoadBanks();
        this.loadCustomers();
        if (Config.multiplePricesOnPOS) {
            this.loadPrices();
            this.loadPricingGroups();
        }
    }

    private void loadCustomers() {
        final Node original = this.searchCustomer.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddExpressSale.this.searchCustomer.setGraphic((Node)Config.getLoader()));
                ObservableList allCustomers = FXCollections.observableArrayList();
                Customer newCust = new Customer();
                allCustomers.add((Object)newCust);
                allCustomers.addAll(new Customer().getAllCustomers(AddExpressSale.this.user));
                newCust.setCustomerNumber("");
                newCust.setCustomerName("Cash Customer");
                allCustomers.sort(Comparator.comparing(Customer::getCustomerName));
                Platform.runLater(() -> {
                    AddExpressSale.this.customer.setItems(allCustomers);
                    AddExpressSale.this.searchCustomer.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void LoadBanks() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {});
                ObservableList<Bank> allBanks = Bank.getAllBanks(AddExpressSale.this.user);
                allBanks.sort(Comparator.comparing(Bank::getCode).reversed());
                Platform.runLater(() -> AddExpressSale.this.cbBank.setItems(allBanks));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadItems() {
        final Node original = this.searchProduct.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddExpressSale.this.searchProduct.setGraphic((Node)Config.getLoader()));
                ObservableList<ShopItem> myItems = new ShopItem().getAllItems(AddExpressSale.this.getUser());
                myItems.sort(Comparator.comparing(ShopItem::getName));
                AddExpressSale.this.allItems = myItems;
                Platform.runLater(() -> {
                    AddExpressSale.this.item.setItems(AddExpressSale.this.allItems);
                    AddExpressSale.this.searchProduct.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadPricingGroups() {
        final PricingGroup walk_in = new PricingGroup();
        walk_in.setId(0);
        walk_in.setName("Retail");
        final ObservableList groups = FXCollections.observableArrayList();
        groups.add((Object)walk_in);
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                groups.addAll(new PricingGroup().getPricingGroups(AddExpressSale.this.getUser()));
                groups.sort(Comparator.comparing(PricingGroup::getName));
                Platform.runLater(() -> {
                    AddExpressSale.this.pricingGroup.setItems(groups);
                    AddExpressSale.this.pricingGroup.setValue((Object)walk_in);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadPrices() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {});
                String response = Config.loadDataFromPhp("masterfetch?type=pricing_group_entries", new HashMap<String, Object>(), AddExpressSale.this.getUser());
                System.out.println(response);
                AddExpressSale.this.pricingEntries = ((HashMap[])new Gson().fromJson(response, HashMap[].class))[0];
                Platform.runLater(() -> {});
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.maskerPane.setVisible(false);
        this.addItemHBox.managedProperty().bind((ObservableValue)this.addItemHBox.visibleProperty());
        this.addPaymentHBox.managedProperty().bind((ObservableValue)this.addPaymentHBox.visibleProperty());
        this.priceLevelHBox.managedProperty().bind((ObservableValue)this.priceLevelHBox.visibleProperty());
        if (Config.multiplePricesOnPOS) {
            this.priceLevelHBox.setVisible(true);
        }
        this.sellingPrice.setDisable(!Config.editPrices);
        this.balance.setText("0.00");
        this.change.setText("0.00");
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        this.g = new Gson();
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.cbBank, Validator.createEmptyValidator((String)"Bank Required"));
        this.addPayment.setOnAction(e -> this.addPayment());
        this.customer.setOnAction(e -> {
            try {
                Customer selectedCustomer = (Customer)this.customer.getValue();
                this.customerName.setText(selectedCustomer.getCustomerName());
                this.buyerKraPin.setText(selectedCustomer.getKraPin());
                this.pricingGroup.setValue((Object)selectedCustomer.getPricingGroup());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.addLine.setOnAction(e -> {
            boolean error = false;
            if (this.labelCode.getText().equals("") && !this.save()) {
                return;
            }
            String code = this.labelCode.getText();
            String itemCode = "";
            double myQuantity = 0.0;
            double mySellingPrice = 0.0;
            String message = "";
            try {
                itemCode = ((ShopItem)this.item.getValue()).getCode();
            }
            catch (Exception ignored) {
                error = true;
                message = "Please select an item";
            }
            try {
                myQuantity = Double.parseDouble(this.quantity.getText().trim());
                if (myQuantity < 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid quantity";
            }
            try {
                mySellingPrice = Double.parseDouble(this.sellingPrice.getText().trim());
                if (mySellingPrice < 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid selling price";
            }
            if (error) {
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.setText(message);
                this.notificationPane.show();
                return;
            }
            this.addLineToDatabase(itemCode, ((ShopItem)this.item.getValue()).getUpcCode(), myQuantity, mySellingPrice);
        });
        PrefixSelectionCustomizer.customize(this.customer);
        PrefixSelectionCustomizer.customize(this.item);
        this.rowCount.setCellFactory(new LineNumbersCellFactory());
        this.colPaymentMethod.setCellValueFactory((Callback)new PropertyValueFactory("paymentMethod"));
        this.colPaymentAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.colTransactionCode.setCellValueFactory((Callback)new PropertyValueFactory("transactionRef"));
        this.tcItem.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        Callback<TableColumn<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments>, TableCell<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments>> deleteCellFactory = new Callback<TableColumn<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments>, TableCell<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments>>(){

            public TableCell<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments> call(TableColumn<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments> param) {
                TableCell<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments> cell = new TableCell<ExpressSale.ExpressSalePayments, ExpressSale.ExpressSalePayments>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            if (AddExpressSale.this.salePosted) {
                                AddExpressSale.this.showDocumentAlreadyPosted();
                            } else {
                                ExpressSale.ExpressSalePayments data = (ExpressSale.ExpressSalePayments)this.getTableView().getItems().get(this.getIndex());
                                if (Config.showConfirmDialog("Delete Payment Line", "The Payment line will be permanently deleted", "Are you sure you want to remove the payment  " + data.getPaymentMethod().toString() + " from this sale?")) {
                                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                    params.put("headerNo", AddExpressSale.this.labelCode.getText());
                                    params.put("lineId", data.getId());
                                    params.put("documentType", DOCUMENT_TYPE);
                                    String response = Config.loadDataFromPhp("masterdelete?type=expresssalepayment", params, AddExpressSale.this.getUser());
                                    System.out.println(response);
                                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                                    if (jr.isStatus()) {
                                        AddExpressSale.this.loadPayments();
                                    }
                                    AddExpressSale.this.notificationPane.setText(jr.getMessage());
                                    AddExpressSale.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    AddExpressSale.this.notificationPane.show();
                                }
                            }
                        });
                    }

                    public void updateItem(ExpressSale.ExpressSalePayments item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getDeleteIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colRemovePayment.setCellFactory((Callback)deleteCellFactory);
        this.colRemovePayment.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback<TableColumn<Object, Object>, TableCell<Object, Object>> cellFactory = new Callback<TableColumn<Object, Object>, TableCell<Object, Object>>(){

            public TableCell<Object, Object> call(TableColumn<Object, Object> param) {
                TableCell<Object, Object> cell = new TableCell<Object, Object>(){
                    private final Hyperlink btn = new Hyperlink();
                    {
                        this.btn.setOnAction(e -> {
                            this.btn.setVisited(false);
                            SalesLines data = (SalesLines)this.getTableView().getItems().get(this.getIndex());
                            AddExpressSale.this.editEntry(data);
                        });
                    }

                    public void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            try {
                                SalesLines data = (SalesLines)item;
                                this.btn.setText(data.getQuantity() + "");
                                this.setGraphic((Node)this.btn);
                            }
                            catch (Exception u) {
                                this.btn.setText(item.toString());
                                this.setGraphic((Node)this.btn);
                                u.printStackTrace();
                            }
                        }
                    }
                };
                return cell;
            }
        };
        Callback<TableColumn<Object, Object>, TableCell<Object, Object>> priceCellFactory = new Callback<TableColumn<Object, Object>, TableCell<Object, Object>>(){

            public TableCell<Object, Object> call(TableColumn<Object, Object> param) {
                TableCell<Object, Object> cell = new TableCell<Object, Object>(){
                    private final Hyperlink btn = new Hyperlink();
                    {
                        this.btn.setOnAction(e -> {
                            this.btn.setVisited(false);
                            SalesLines data = (SalesLines)this.getTableView().getItems().get(this.getIndex());
                            AddExpressSale.this.editEntry(data);
                        });
                    }

                    public void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            try {
                                SalesLines data = (SalesLines)item;
                                this.btn.setText(data.getUnitPriceString());
                                this.setGraphic((Node)this.btn);
                            }
                            catch (Exception u) {
                                this.btn.setText(item.toString());
                                this.setGraphic((Node)this.btn);
                                u.printStackTrace();
                            }
                        }
                    }
                };
                return cell;
            }
        };
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.tcPrice.setCellFactory((Callback)priceCellFactory);
        this.tcPrice.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback<TableColumn<SalesLines, SalesLines>, TableCell<SalesLines, SalesLines>> deletePaymentCellFactory = new Callback<TableColumn<SalesLines, SalesLines>, TableCell<SalesLines, SalesLines>>(){

            public TableCell<SalesLines, SalesLines> call(TableColumn<SalesLines, SalesLines> param) {
                TableCell<SalesLines, SalesLines> cell = new TableCell<SalesLines, SalesLines>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            if (AddExpressSale.this.salePosted) {
                                AddExpressSale.this.showDocumentAlreadyPosted();
                            } else {
                                SalesLines data = (SalesLines)this.getTableView().getItems().get(this.getIndex());
                                if (Config.showConfirmDialog("Delete Sales Line", "The Sales line will be permanently deleted", "Are you sure you want to remove the item " + data.getDescription() + " from this sale?")) {
                                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                    params.put("headerNo", AddExpressSale.this.labelCode.getText());
                                    params.put("itemType", data.getItemType());
                                    params.put("lineId", data.getLineId());
                                    params.put("documentType", DOCUMENT_TYPE);
                                    String response = Config.loadDataFromPhp("masterdelete?type=salesline", params, AddExpressSale.this.getUser());
                                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                                    if (jr.isStatus()) {
                                        AddExpressSale.this.loadLines();
                                    }
                                    AddExpressSale.this.notificationPane.setText(jr.getMessage());
                                    AddExpressSale.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    AddExpressSale.this.notificationPane.show();
                                }
                            }
                        });
                    }

                    public void updateItem(SalesLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getDeleteIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.tcRemove.setCellFactory((Callback)deletePaymentCellFactory);
        this.tcRemove.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.tcTotal.setCellValueFactory((Callback)new PropertyValueFactory("totalAmountString"));
        this.totalLabel.prefWidthProperty().bind((ObservableValue)this.rowCount.widthProperty().add((ObservableNumberValue)this.tcItem.widthProperty()).add((ObservableNumberValue)this.tcPrice.widthProperty()));
        this.totalQuantity.prefWidthProperty().bind((ObservableValue)this.tcQuantity.widthProperty());
        this.receiptTotal.prefWidthProperty().bind((ObservableValue)this.tcTotal.widthProperty());
        this.searchCustomer.setOnAction(e -> {
            Gson gson = new Gson();
            String response2 = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.customer.getItems()), this.getUser());
            Customer myCustomer = (Customer)gson.fromJson(response2, Customer.class);
            this.customer.setValue((Object)myCustomer);
        });
        this.item.setOnAction(e -> {
            ShopItem selectedItem = (ShopItem)this.item.getValue();
            double mSelling = this.getSellingPrice(selectedItem.getCode(), selectedItem.getPrice());
            this.sellingPrice.setText(mSelling + "");
        });
        this.searchProduct.setOnAction(e -> {
            Gson gson = new Gson();
            String response2 = new Config().getObjectFromSelection("shopitem", gson.toJson(this.getAllItems()), this.getUser());
            ShopItem itemSelection = (ShopItem)gson.fromJson(response2, ShopItem.class);
            boolean error = false;
            String errorMessage = "";
            double unitPrice = 0.0;
            if (this.labelCode.getText().equals("") && !this.save()) {
                return;
            }
            String code = this.labelCode.getText();
            try {
                if (!error) {
                    LinkedHashMap params = new LinkedHashMap();
                    String itemCode = itemSelection.getCode();
                    double mSelling = this.getSellingPrice(itemCode, itemSelection.getPrice());
                    this.addLineToDatabase(itemCode, itemSelection.getUpcCode(), 1.0, mSelling);
                } else {
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.setText(errorMessage);
                    this.notificationPane.show();
                }
            }
            catch (NullPointerException params) {
            }
            catch (Exception u) {
                u.printStackTrace();
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.show();
            }
        });
    }

    private void showDocumentAlreadyPosted() {
        this.notificationPane.setText("You cannot make any changes as the document has already been posted");
        this.notificationPane.setGraphic((Node)Config.getBanIcon());
        this.notificationPane.show();
    }

    private boolean addPayment() {
        if (this.save()) {
            int bankCode = 0;
            double tAmount = 0.0;
            String tTransactionRef = "";
            boolean error = false;
            String message = "";
            try {
                String mAmount = this.amount.getText().trim();
                if (mAmount.length() < 1) {
                    return true;
                }
                tAmount = Double.parseDouble(mAmount);
                if (tAmount == 0.0) {
                    return true;
                }
            }
            catch (Exception u) {
                error = true;
                message = "Please enter a valid amount";
            }
            try {
                bankCode = ((Bank)this.cbBank.getValue()).getCode();
            }
            catch (Exception u) {
                error = true;
                message = "Please select a payment method";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
                return false;
            }
            try {
                tTransactionRef = this.tfExtDoc.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("saleCode", this.labelCode.getText());
                params.put("amount", tAmount);
                params.put("bankCode", bankCode);
                params.put("transactionRef", tTransactionRef);
                String response = Config.loadDataFromPhp("mastercreate?type=expresssalepayment", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.cbBank.setValue(null);
                    this.tfExtDoc.setText("");
                    this.loadPayments();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception o) {
                o.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                return false;
            }
        }
        return false;
    }

    private void loadPayments() {
        ObservableList<ExpressSale.ExpressSalePayments> myLines = new ExpressSale().getPayments(this.labelCode.getText().trim(), this.getUser());
        this.allPayments.setItems(myLines);
        this.computeBalances();
    }

    private void computeBalances() {
        try {
            double totalSales = 0.0;
            double totalPayments = 0.0;
            double tTotalQuantity = 0.0;
            try {
                totalSales = this.tvLines.getItems().stream().mapToDouble(SalesLines::getTotalAmount).sum();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tTotalQuantity = this.tvLines.getItems().stream().mapToDouble(SalesLines::getQuantity).sum();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                totalPayments = this.allPayments.getItems().stream().mapToDouble(ExpressSale.ExpressSalePayments::getAmount).sum();
            }
            catch (Exception exception) {
                // empty catch block
            }
            double tBalance = totalSales - totalPayments;
            double tChange = 0.0;
            if (tBalance < 0.0) {
                tChange = tBalance * -1.0;
                tBalance += tChange;
            }
            this.receiptTotal.setText(Config.formatNumber(totalSales));
            this.totalQuantity.setText(Config.formatNumber(tTotalQuantity));
            this.balance.setText(Config.formatNumber(tBalance));
            this.change.setText(Config.formatNumber(tChange));
            this.amount.setText(tBalance + "");
        }
        catch (Exception p) {
            p.printStackTrace();
        }
    }

    @FXML
    void addLine(ActionEvent event) {
        this.addLine();
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbAddSale.getScene().getWindow();
        stage.fireEvent((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void postSale(ActionEvent event) {
        if (this.save() && this.addPayment()) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("docNo", this.labelCode.getText().trim());
            params.put("docType", DOCUMENT_TYPE);
            new Config();
            String response = Config.loadDataFromPhp("masterpost?type=salesheader", params, this.getUser());
            System.out.println(response);
            JsonResponses jsonResponses = (JsonResponses)this.g.fromJson(response, JsonResponses.class);
            if (jsonResponses.isStatus()) {
                this.customer.setDisable(true);
                this.searchCustomer.setDisable(true);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", Config.saccoName);
                reportVariables.put("servedBy", this.user.getUserName());
                reportVariables.put("printedOn", "Printed on " + Config.getSystemTime());
                reportVariables.put("kraPIN", Config.getKRAPin());
                reportVariables.put("buyerKraPin", Config.getBuyerKRAPinPrefix() + this.buyerKraPin.getText());
                reportVariables.put("address", Config.companyAddress);
                reportVariables.put("receiptNo", this.labelCode.getText());
                reportVariables.put("receiptDate", Config.localDateToString(Config.getCurrentLocaldate()));
                reportVariables.put("saleDate", Config.localDateToString(Config.getCurrentLocaldate()));
                reportVariables.put("customerName", this.customerName.getText());
                reportVariables.put("buyerKraPin", this.buyerKraPin.getText());
                reportVariables.put("customerPin", this.buyerKraPin.getText());
                reportVariables.put("address", Config.companyAddress);
                reportVariables.put("change", this.change.getText());
                String data = new Gson().toJson((Object)this.tvLines.getItems());
                if (Config.eTIMSIntegration) {
                    try {
                        HashMap signature = (HashMap)this.g.fromJson(response, HashMap.class);
                        LinkedTreeMap signature1 = (LinkedTreeMap)signature.get("signature");
                        LinkedTreeMap signature2 = (LinkedTreeMap)signature1.get((Object)"data");
                        String qrCode = (String)signature1.getOrDefault((Object)"qrCode", (Object)"");
                        String invcNo = (String)signature1.getOrDefault((Object)"invcNo", (Object)"");
                        String cuSerialNo = (String)signature2.getOrDefault((Object)"sdcId", (Object)"");
                        String cuInvoiceNo = cuSerialNo + "/" + invcNo;
                        String internalData = (String)signature2.getOrDefault((Object)"intrlData", (Object)"");
                        String receiptSignature = (String)signature2.getOrDefault((Object)"rcptSign", (Object)"");
                        reportVariables.put("qrCode", qrCode);
                        reportVariables.put("cuSerialNo", cuSerialNo);
                        reportVariables.put("cuInvoiceNo", cuInvoiceNo);
                        reportVariables.put("internalData", internalData);
                        reportVariables.put("receiptSignature", receiptSignature);
                    }
                    catch (Exception signature) {
                        // empty catch block
                    }
                }
                try {
                    if (!jsonResponses.getOverLoad2().equalsIgnoreCase("saveToFile")) {
                        throw new Exception();
                    }
                    new Config().saveJsonReportAsPDF("Express Sale", data, "expresssale58mm.jasper", reportVariables, this.getUser(), "receipt" + this.labelCode.getText() + ".pdf");
                }
                catch (Exception ignored) {
                    new Config().printReportWithJson("Express Sale", data, "expresssale58mm.jasper", reportVariables);
                }
                this.labelCode.setText("");
                this.tvLines.setItems(null);
                this.receiptTotal.setText("0");
                this.totalQuantity.setText("0");
                this.balance.setText("0");
                this.change.setText("0");
                this.allPayments.setItems(null);
                this.cbBank.setValue(null);
                this.tfExtDoc.setText("");
                this.buyerKraPin.setText("");
                this.customerName.setText("");
                this.customer.setValue(null);
            }
            this.notificationPane.setGraphic((Node)jsonResponses.getIconFromStatus());
            this.notificationPane.setText(jsonResponses.getMessage());
            this.notificationPane.show();
        }
    }

    @FXML
    void reverseSale(ActionEvent event) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("code", this.labelCode.getText().trim());
        new Config();
        String response = Config.loadDataFromPhp("masterpost?type=reverseexpressSale", params, this.getUser());
        System.out.println(response);
        JsonResponses jsonResponses = (JsonResponses)this.g.fromJson(response, JsonResponses.class);
        if (jsonResponses.isStatus()) {
            Stage stage = (Stage)this.vbAddSale.getScene().getWindow();
            stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
        } else {
            this.notificationPane.setText(jsonResponses.getMessage());
            this.notificationPane.show();
        }
    }

    @FXML
    void saveSale(ActionEvent event) {
        if (this.save()) {
            Stage stage = (Stage)this.vbAddSale.getScene().getWindow();
            stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    }

    private boolean save() {
        String myCustomerPin;
        String myCustomerName;
        boolean error = false;
        String errorMessage = "";
        String docNo = this.labelCode.getText();
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
            return false;
        }
        String tCustomerCode = "";
        try {
            tCustomerCode = ((Customer)this.customer.getValue()).getCustomerNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", docNo);
        params.put("customer", tCustomerCode);
        params.put("date", Config.getCurrentLocaldate());
        params.put("sourceLocation", this.getUser().getStore_location());
        params.put("invoice", "");
        params.put("region", "");
        params.put("salesRep", "");
        params.put("document_type", DOCUMENT_TYPE);
        params.put("projectCode", "");
        params.put("comment", "");
        params.put("reference", "");
        try {
            myCustomerName = this.customerName.getText().trim();
        }
        catch (Exception ignored) {
            myCustomerName = "";
        }
        try {
            myCustomerPin = this.buyerKraPin.getText().trim();
        }
        catch (Exception ignored) {
            myCustomerPin = "";
        }
        params.put("customerName", myCustomerName);
        params.put("customerPin", myCustomerPin);
        String response = Config.loadDataFromPhp("mastercreate?type=salesheader", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)this.g.fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            this.labelCode.setText(jr.getOverLoad1());
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)Config.getCheckIcon());
            this.notificationPane.show();
            return true;
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }

    private boolean save2() {
        boolean error = false;
        String errorMessage = "";
        NumberSeries ns = new NumberSeries(41, this.getUser());
        String code = this.labelCode.getText().length() < 1 ? ns.getNextNumber() : this.labelCode.getText();
        String docNo = "";
        int selectedBank = 0;
        try {
            docNo = this.tfExtDoc.getText();
        }
        catch (Exception e) {
            docNo = "";
        }
        try {
            selectedBank = ((Bank)this.cbBank.getValue()).getCode();
        }
        catch (Exception e) {
            selectedBank = 0;
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
            return false;
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("code", code);
        params.put("docNo", docNo);
        params.put("bank", selectedBank);
        new Config();
        String response = Config.loadDataFromPhp("mastercreate?type=expresssale", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)this.g.fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            if (this.labelCode.getText().length() < 1) {
                ns.updateLastUsed(ns.getNextNumber());
            }
            this.labelCode.setText(code);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)Config.getCheckIcon());
            this.notificationPane.show();
            return true;
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }

    private boolean addLine() {
        boolean error = false;
        String errorMessage = "";
        if (this.labelCode.getText().equals("") && !this.save()) {
            return false;
        }
        String code = this.labelCode.getText();
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
            return false;
        }
        LinkedHashMap params = new LinkedHashMap();
        String upcCode = this.productCode.getText().trim();
        this.addLineToDatabase(null, upcCode, 1.0, null);
        return false;
    }

    public void setSale(SalesHeader sale) {
        this.sale = sale;
        this.labelCode.setText(sale.getDoc_no());
        this.customerName.setText(sale.getCustomerName());
        this.buyerKraPin.setText(sale.getCustomerPin());
        this.loadLines();
        this.loadPayments();
        if (sale.isPosted()) {
            this.btnSave.setDisable(true);
            this.btnPost.setDisable(true);
            this.addItemHBox.setVisible(false);
            this.addPaymentHBox.setVisible(false);
            this.tvLines.getColumns().remove((Object)this.tcRemove);
            this.allPayments.getColumns().remove((Object)this.colRemovePayment);
            this.salePosted = true;
        }
    }

    public ObservableList<ShopItem> getAllItems() {
        if (this.allItems.size() == 0) {
            ObservableList<ShopItem> myItems = new ShopItem().getAllItems(this.getUser());
            this.allItems = myItems;
        }
        return this.allItems;
    }

    public void loadLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddExpressSale.this.maskerPane.setVisible(true));
                ObservableList<SalesLines> myLines = new SalesLines().getAllLines(AddExpressSale.this.labelCode.getText().trim(), DOCUMENT_TYPE, AddExpressSale.this.getUser());
                Platform.runLater(() -> {
                    AddExpressSale.this.tvLines.setItems(myLines);
                    if (myLines.size() > 0) {
                        AddExpressSale.this.customer.setDisable(true);
                        AddExpressSale.this.searchCustomer.setDisable(true);
                        AddExpressSale.this.customerName.setDisable(true);
                        AddExpressSale.this.buyerKraPin.setDisable(true);
                    } else {
                        AddExpressSale.this.customer.setDisable(false);
                        AddExpressSale.this.searchCustomer.setDisable(false);
                        AddExpressSale.this.customerName.setDisable(false);
                        AddExpressSale.this.buyerKraPin.setDisable(false);
                    }
                    AddExpressSale.this.computeBalances();
                    AddExpressSale.this.maskerPane.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editQuantity(int lineId, String quantity) {
        System.out.println("Editing Quantity");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("lineId", lineId);
        params.put("quantity", Double.parseDouble(quantity));
        String response = Config.loadDataFromPhp("masterupdate?type=salesline", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            this.loadLines();
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
    }

    public void editPrice(int lineId, String editedUnitPrice) {
        System.out.println("Editing Selling Price");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("lineId", lineId);
        params.put("unitPrice", Double.parseDouble(editedUnitPrice));
        String response = Config.loadDataFromPhp("masterupdate?type=salesline", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            this.loadLines();
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
    }

    public void addLineToDatabase(String itemCode, String upcCode, double myQuantity, Double mySellingPrice) {
        if (this.save()) {
            int tPricingGroup = 0;
            try {
                tPricingGroup = ((PricingGroup)this.pricingGroup.getValue()).getId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("headerNo", this.labelCode.getText().trim());
            params.put("documentType", DOCUMENT_TYPE);
            params.put("itemType", "Items");
            params.put("itemNo", itemCode);
            params.put("upcCode", upcCode);
            params.put("description", "");
            params.put("unitPrice", mySellingPrice);
            params.put("quantity", myQuantity);
            params.put("discount", 0);
            params.put("kilometres", 0);
            params.put("vehicle", "");
            params.put("pricingGroup", tPricingGroup);
            String response = Config.loadDataFromPhp("mastercreate?type=salesline", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.productCode.setText("");
                this.loadLines();
                this.quantity.setText("1");
                this.sellingPrice.setText("");
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
    }

    public void editEntry(SalesLines details) {
        if (this.salePosted) {
            this.showDocumentAlreadyPosted();
        } else {
            try {
                final Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/edit_sales_line.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                EditSalesLineController controller = (EditSalesLineController)loader.getController();
                controller.setUser(this.getUser());
                controller.setItems((ObservableList<ShopItem>)this.item.getItems());
                controller.setDocumentType(DOCUMENT_TYPE);
                controller.setLine(details);
                stage.setTitle("Edit Sale Line");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AddExpressSale.this.loadLines();
                            }
                        });
                    }
                });
                stage.showAndWait();
            }
            catch (Exception p) {
                this.notificationPane.setText("An error occurred while loading your edit record screen. Please contact support");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
    }

    public double getSellingPrice(String productCode, double defaultSellingPrice) {
        if (Config.multiplePricesOnPOS) {
            try {
                int pricingGroupId = ((PricingGroup)this.pricingGroup.getValue()).getId();
                if (pricingGroupId > 0) {
                    String key = productCode + "group" + pricingGroupId;
                    System.out.println("Key: " + key);
                    double price = Double.parseDouble(this.pricingEntries.getOrDefault(key, 0.0) + "");
                    System.out.println("Price: " + price);
                    if (price > 0.0) {
                        return price;
                    }
                    throw new Exception();
                }
            }
            catch (Exception u) {
                u.printStackTrace();
            }
        }
        return defaultSellingPrice;
    }
}

