/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.PublicHoliday;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddHoliday
implements Initializable {
    private User user;
    private PublicHoliday publicHoliday;
    @FXML
    private VBox vbAddHoliday;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private TextField tfName;
    @FXML
    private CheckBox cbAnnual;
    @FXML
    private DatePicker dpDate;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.btnSave.setDisable(false);
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
            ValidationSupport vs = new ValidationSupport();
            vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Name is required"));
        });
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbAddHoliday.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void save(ActionEvent event) {
        String name = this.tfName.getText().trim();
        String date = "";
        boolean error = false;
        String errorMessage = "";
        if (name.length() == 0 || name.equals("")) {
            this.notificationPane.setText("Enter a valid name");
            this.notificationPane.show();
            return;
        }
        try {
            date = Config.localDateToString((LocalDate)this.dpDate.getValue());
        }
        catch (Exception e) {
            this.notificationPane.setText("Select a valid date");
            this.notificationPane.show();
            return;
        }
        boolean annual = this.cbAnnual.isSelected();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (!this.labelId.getText().trim().equals("")) {
            params.put("id", this.labelId.getText().trim());
        }
        params.put("name", name);
        params.put("date", date);
        params.put("annual", annual ? 1 : 0);
        String url = this.labelId.getText().trim().equals("") ? "mastercreate" : "masterupdate";
        String response = Config.loadDataFromPhp(url + "?type=holidays", params, this.getUser());
        System.out.println(response);
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.show();
        if (jr.isStatus()) {
            Stage stage = (Stage)this.vbHolder.getScene().getWindow();
            stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
        }
    }

    public void setPublicHoliday(PublicHoliday publicHoliday) {
        this.publicHoliday = publicHoliday;
        this.labelId.setText(publicHoliday.getId() + "");
        this.tfName.setText(publicHoliday.getName());
        this.cbAnnual.setSelected(publicHoliday.isAnnual());
        this.dpDate.setValue((Object)Config.stringToLocalDate(publicHoliday.getDate()));
        this.btnSave.setDisable(false);
    }
}

