/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.Investment;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.animation.PauseTransition;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Duration;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddInvestmentController
implements Initializable {
    private User user;
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private ComboBox<Account> glAccount;
    @FXML
    private Label investmentNo;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TextField investmentName;
    @FXML
    private TextArea investmentDescription;
    @FXML
    private DatePicker startDate;
    @FXML
    private JFXButton addInvestment;
    @FXML
    private JFXButton cancel;
    private Investment investment;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Investment getInvestment() {
        return this.investment;
    }

    public void setInvestment(Investment investment) {
        this.investment = investment;
        try {
            this.glAccount.setValue((Object)investment.getGlAccount());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.investmentNo.setText(investment.getInvestmentNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.investmentName.setText(investment.getInvestmentName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.investmentDescription.setText(investment.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.startDate.setValue((Object)Config.stringToLocalDate(investment.getStartDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.startDate.setValue((Object)Config.getCurrentLocaldate());
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.investmentNo, Validator.createEmptyValidator((String)"Investment Number is required"));
        validationSupport.registerValidator((Control)this.investmentDescription, Validator.createEmptyValidator((String)"Description is required"));
        validationSupport.registerValidator((Control)this.investmentName, Validator.createEmptyValidator((String)"Investment Name is required"));
        validationSupport.registerValidator((Control)this.startDate, Validator.createEmptyValidator((String)"Start Date is required"));
        validationSupport.registerValidator(this.glAccount, Validator.createEmptyValidator((String)"G/L Account is required"));
        this.glAccount.setItems(Account.getAccounts(this.getUser()));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.addInvestment.setOnAction(e -> {
            String tInvestmentNo = this.investmentNo.getText().trim();
            String tInvestmentDescription = this.investmentDescription.getText().trim();
            String tInvestmentName = this.investmentName.getText().trim();
            LocalDate statD = (LocalDate)this.startDate.getValue();
            String tGlAccount = "";
            String date = "";
            boolean error = false;
            boolean newInvestment = false;
            String message = "";
            NumberSeries ns = new NumberSeries(24, this.getUser());
            try {
                if (tInvestmentNo.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception t) {
                tInvestmentNo = ns.getNextNumber();
                newInvestment = true;
            }
            try {
                date = Config.localDateToString(statD);
            }
            catch (Exception t) {
                error = true;
                message = "Please select a valid value for start date";
            }
            if (tInvestmentDescription.length() < 1) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter some value for description";
            }
            if (tInvestmentName.length() < 1) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter some value for investment name";
            }
            try {
                tGlAccount = ((Account)this.glAccount.getValue()).getAccountNumber();
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the G/L Account for this investment";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("investmentNo", tInvestmentNo);
                    params.put("investmentName", tInvestmentName);
                    params.put("investmentDescription", tInvestmentDescription);
                    params.put("startDate", date);
                    params.put("glAccount", tGlAccount);
                    String response2 = Config.loadDataFromPhp("mastercreate?type=addinvestment", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                    this.notificationPane.show();
                    if (myResponse.isStatus() && newInvestment) {
                        ns.updateLastUsed(tInvestmentNo);
                        this.investmentNo.setText(tInvestmentNo);
                    }
                }
                catch (Exception t) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public void clear() {
        this.investmentNo.setText(null);
        this.investmentDescription.setText(null);
        this.investmentName.setText(null);
        this.startDate.setValue(null);
    }

    public void notificationPaneHide() {
        PauseTransition show_time = new PauseTransition(Duration.seconds((double)2.0));
        show_time.setOnFinished(event -> this.notificationPane.hide());
        show_time.play();
    }
}

