/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.ItemBrand;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddItemBrand
implements Initializable {
    private User user;
    @FXML
    private VBox vbBrand;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private TextField tfName;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            ValidationSupport vs = new ValidationSupport();
            vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Required"));
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        });
    }

    @FXML
    void cancel(ActionEvent event) {
        this.vbBrand.getScene().getWindow().hide();
    }

    @FXML
    void saveBrand(ActionEvent event) {
        String name = this.tfName.getText().trim();
        Gson g = new Gson();
        if (name.length() < 1) {
            this.notificationPane.setText("Brand Name is required");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", name);
            String id = this.labelId.getText().trim();
            if (id.length() != 0 || !id.equals("")) {
                map.put("id", id);
            }
            new Config();
            String response = Config.loadDataFromPhp("mastercreate?type=itembrand", map, this.getUser());
            System.out.print(response);
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.vbBrand.getScene().getWindow().hide();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public void setItemBrand(ItemBrand itemBrand) {
        if (itemBrand != null) {
            this.labelId.setText(String.valueOf(itemBrand.getId()));
            this.tfName.setText(itemBrand.getName());
        }
    }
}

