/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddMemberController
implements Initializable {
    private User user;
    String imagePath = "";
    @FXML
    private TextField firstName;
    @FXML
    private TextField middleName;
    @FXML
    private TextField lastName;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private TextField idNumber;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private DatePicker dateOfBirth;
    @FXML
    private TextField kraPin;
    @FXML
    AnchorPane holder;
    @FXML
    private JFXButton addMember;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private JFXButton reset;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/holder.png";
        this.reset.setOnAction(e -> this.clear());
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)AddMemberController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.firstName, Validator.createEmptyValidator((String)"First name is required"));
        validationSupport.registerValidator((Control)this.lastName, Validator.createEmptyValidator((String)"Last name is required"));
        validationSupport.registerValidator((Control)this.idNumber, Validator.createEmptyValidator((String)"Id number is required"));
        validationSupport.registerValidator((Control)this.phoneNumber, Validator.createEmptyValidator((String)"Phone number is required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.addMember.setOnAction(e -> {
            this.addMember.setDisable(true);
            String fileLocation = myPath + "/loading.gif";
            File file = new File(fileLocation);
            String fName = this.firstName.getText().trim();
            String mName = this.middleName.getText().trim();
            String lName = this.lastName.getText().trim();
            String idNo = this.idNumber.getText().trim();
            String phoneNo = this.phoneNumber.getText().trim();
            String email = this.emailAddress.getText().trim();
            String pin = this.kraPin.getText().trim();
            LocalDate dob = (LocalDate)this.dateOfBirth.getValue();
            try {
                Date date = Date.from(dob.atStartOfDay(ZoneId.systemDefault()).toInstant());
            }
            catch (NullPointerException t) {
                Date date = new Date();
            }
            boolean error = false;
            String message = "";
            try {
                Image image2 = new Image(file.toURI().toString());
                ImageView image = new ImageView(image2);
                image.setFitHeight(30.0);
                image.setFitWidth(30.0);
                this.notificationPane.setGraphic((Node)image);
                this.notificationPane.setText("Adding member. Please wait...");
                this.notificationPane.show();
                NumberSeries nb = new NumberSeries(1, this.getUser());
                String memberNumber = nb.getNextNumber();
                ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
                String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", memberNumber);
                params.put("fName", fName);
                params.put("mName", mName);
                params.put("lName", lName);
                params.put("idNo", idNo);
                params.put("phoneNo", phoneNo);
                params.put("email", email);
                params.put("pin", pin);
                params.put("photo", photoJson);
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("mastercreate?type=member", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                    nb.updateLastUsed(memberNumber);
                    this.clear();
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                }
                this.addMember.setDisable(false);
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.addMember.setDisable(false);
            }
        });
    }

    public void clear() {
        this.firstName.setText(null);
        this.middleName.setText(null);
        this.lastName.setText(null);
        this.idNumber.setText(null);
        this.phoneNumber.setText(null);
        this.emailAddress.setText(null);
        this.dateOfBirth.setValue(null);
        this.kraPin.setText(null);
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.profilePhoto.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

