/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.BillOfMaterial;
import classes.ChargeItem;
import classes.Config;
import classes.Countries;
import classes.ItemBrand;
import classes.JsonResponses;
import classes.PostingGroup;
import classes.PricingGroup;
import classes.ShopItem;
import classes.TaxGroup;
import classes.UnitOfMeasure;
import classes.UnitOfMeasureRelationships;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import controllers.ItemEntriesController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddShopItem
implements Initializable {
    boolean newProduct = true;
    private User user;
    private ShopItem item;
    @FXML
    private VBox apAddItem;
    @FXML
    private Label labelCode;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfDescription;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfDiscount;
    @FXML
    private ComboBox<ItemBrand> cbBrand;
    @FXML
    private ComboBox<UnitOfMeasure> cbUOM;
    @FXML
    private ComboBox<TaxGroup> cbTaxGroup;
    @FXML
    private ComboBox<PostingGroup> cbPostingGroup;
    @FXML
    private ComboBox<Countries> countryOfOrigin;
    @FXML
    private TextField dmsNo;
    @FXML
    private ComboBox<ShopItem.ItemClassification> itemClassification;
    @FXML
    private ComboBox<ShopItem.ItemType> itemType;
    @FXML
    private ComboBox<UnitOfMeasure> packagingUnit;
    @FXML
    private TextField tfUPC;
    @FXML
    private ImageView ivImage;
    @FXML
    private Button btnSave;
    @FXML
    private Button sendToEtims;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private ComboBox<UnitOfMeasure> relationshipUnitOfMeasure;
    @FXML
    private TextField relationshipQuantity;
    @FXML
    private TextField relationshipSellingPrice;
    @FXML
    private Button addRelationShip;
    @FXML
    private TableView<UnitOfMeasureRelationships> allRelationships;
    @FXML
    private TableColumn colUnitOfMeasure;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colSellingPrice;
    @FXML
    private TextField reOrderLevel;
    @FXML
    private TabPane holder;
    private String imagePath;
    private String imageName;
    private String photoJson = "";
    private final String userDir = System.getProperty("user.dir");
    private final String holderImage = "file:///" + this.userDir + "\\kuzalogo.png";
    @FXML
    private TableView<PricingGroup.PricingGroupEntries> allPricingGroups;
    @FXML
    private TableColumn colGroup;
    @FXML
    private TableColumn colGroupSellingPrice;
    @FXML
    private TextField buyingPrice;
    @FXML
    private ComboBox<PricingGroup> pricingGroup;
    @FXML
    private TextField groupSellingPrice;
    @FXML
    private Button addGroupSellingPrice;
    @FXML
    private Hyperlink availableQuantity;
    @FXML
    private ComboBox compositionItem;
    @FXML
    private TextField compositionQuantity;
    @FXML
    private Button addComposition;
    @FXML
    private MaskerPane materialsMasker;
    @FXML
    private TableView<BillOfMaterial> allComposition;
    @FXML
    private TableColumn colCompositionItemType;
    @FXML
    private TableColumn colCompositionItemCode;
    @FXML
    private TableColumn colCompositionItemName;
    @FXML
    private TableColumn colCompositionQuantity;
    @FXML
    private TableColumn colCompositionRemove;
    @FXML
    private TableColumn colCompositionCompositionMethod;
    @FXML
    private ComboBox<String> compositionItemType;
    @FXML
    private ComboBox<String> computationMethod;
    @FXML
    private Button compositionSearchItem;
    @FXML
    private TableView<HashMap> fullStock;
    @FXML
    private TableColumn colLocation;
    @FXML
    private TableColumn colFullStock;
    @FXML
    private MaskerPane fullStockMasker;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Platform.runLater(() -> {
            ObservableList myUnits2;
            this.cbBrand.setItems(FXCollections.observableArrayList(new ItemBrand().getAllBrands(this.getUser())));
            this.cbTaxGroup.setItems(FXCollections.observableArrayList(new TaxGroup().getAllTaxGroups(this.getUser())));
            ObservableList unitsOfMeasure = FXCollections.observableArrayList(new UnitOfMeasure().getAllUOMs(this.getUser()));
            ObservableList countries = FXCollections.observableArrayList(new Countries().getAllCountries(this.getUser()));
            ObservableList<ShopItem.ItemClassification> classifications = new ShopItem().getAllClassification(this.getUser());
            ObservableList<ShopItem.ItemType> itemTypes = new ShopItem().getItemTypes(this.getUser());
            ObservableList measureUnits = null;
            ObservableList packagingUnits = null;
            try {
                measureUnits = FXCollections.observableArrayList((Collection)unitsOfMeasure.stream().filter(v -> v.getType().equalsIgnoreCase("Quantity")).collect(Collectors.toList()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                packagingUnits = FXCollections.observableArrayList((Collection)unitsOfMeasure.stream().filter(v -> v.getType().equalsIgnoreCase("Packaging")).collect(Collectors.toList()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cbUOM.setItems(measureUnits);
            this.relationshipUnitOfMeasure.setItems(measureUnits);
            this.packagingUnit.setItems(packagingUnits);
            this.pricingGroup.setItems(new PricingGroup().getPricingGroups(user));
            this.countryOfOrigin.setItems(countries);
            this.itemClassification.setItems(classifications);
            this.itemType.setItems(itemTypes);
            this.cbPostingGroup.setItems(FXCollections.observableArrayList(new PostingGroup().getAllPostingGroups(3, this.getUser())));
            try {
                ObservableList myTypes = FXCollections.observableArrayList((Collection)itemTypes.stream().filter(v -> v.getCode().equalsIgnoreCase("2")).collect(Collectors.toList()));
                this.itemType.setValue(myTypes.get(0));
            }
            catch (Exception myTypes) {
                // empty catch block
            }
            try {
                ObservableList myClasses = FXCollections.observableArrayList((Collection)classifications.stream().filter(v -> v.getCode().equalsIgnoreCase("5020220050")).collect(Collectors.toList()));
                this.itemClassification.setValue(myClasses.get(0));
            }
            catch (Exception myClasses) {
                // empty catch block
            }
            try {
                ObservableList myCountries = FXCollections.observableArrayList((Collection)countries.stream().filter(v -> v.getCode().equalsIgnoreCase("AE")).collect(Collectors.toList()));
                this.countryOfOrigin.setValue(myCountries.get(0));
            }
            catch (Exception myCountries) {
                // empty catch block
            }
            try {
                myUnits2 = FXCollections.observableArrayList((Collection)measureUnits.stream().filter(v -> v.getId().equalsIgnoreCase("U")).collect(Collectors.toList()));
                this.cbUOM.setValue(myUnits2.get(0));
            }
            catch (Exception myUnits2) {
                // empty catch block
            }
            try {
                myUnits2 = FXCollections.observableArrayList((Collection)packagingUnits.stream().filter(v -> v.getId().equalsIgnoreCase("BQ")).collect(Collectors.toList()));
                this.packagingUnit.setValue(myUnits2.get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadItemCompositionProducts();
        });
    }

    public ShopItem getItem() {
        return this.item;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.materialsMasker.setVisible(false);
        this.btnSave.setDisable(!Config.ERP_MODE);
        this.addGroupSellingPrice.setDisable(!Config.ERP_MODE);
        this.sendToEtims.setDisable(!Config.ERP_MODE);
        this.compositionItemType.getItems().add((Object)"Items");
        this.compositionItemType.getItems().add((Object)"Services");
        this.compositionItemType.setValue(this.compositionItemType.getItems().get(0));
        this.computationMethod.getItems().add((Object)"Fixed");
        this.computationMethod.getItems().add((Object)"Percentage of Costs");
        this.computationMethod.setValue(this.computationMethod.getItems().get(0));
        this.computationMethod.setDisable(true);
        PrefixSelectionCustomizer.customize(this.countryOfOrigin);
        PrefixSelectionCustomizer.customize(this.cbBrand);
        PrefixSelectionCustomizer.customize(this.cbUOM);
        PrefixSelectionCustomizer.customize(this.packagingUnit);
        PrefixSelectionCustomizer.customize(this.cbTaxGroup);
        PrefixSelectionCustomizer.customize(this.itemClassification);
        PrefixSelectionCustomizer.customize(this.itemType);
        PrefixSelectionCustomizer.customize(this.cbPostingGroup);
        this.fullStockMasker.setVisible(false);
        this.sendToEtims.setVisible(Config.eTIMSIntegration);
        this.tfPrice = new Config().setDoubleTextField(this.tfPrice);
        this.tfDiscount = new Config().setDoubleTextField(this.tfDiscount);
        this.relationshipQuantity = new Config().setDoubleTextField(this.relationshipQuantity);
        this.relationshipSellingPrice = new Config().setDoubleTextField(this.relationshipSellingPrice);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfDescription, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfPrice, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbBrand, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbTaxGroup, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbUOM, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.cbPostingGroup, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.tfUPC, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.relationshipQuantity, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.relationshipUnitOfMeasure, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.relationshipSellingPrice, Validator.createEmptyValidator((String)"Required"));
        this.colUnitOfMeasure.setCellValueFactory((Callback)new PropertyValueFactory("unitOfMeasure"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colSellingPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colGroup.setCellValueFactory((Callback)new PropertyValueFactory("group"));
        this.colGroupSellingPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPriceString"));
        this.colCompositionItemType.setCellValueFactory((Callback)new PropertyValueFactory("itemType"));
        this.colCompositionCompositionMethod.setCellValueFactory((Callback)new PropertyValueFactory("computationMethod"));
        this.colCompositionItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colCompositionItemName.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colLocation.setCellValueFactory((Callback)new MapValueFactory((Object)"location"));
        Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>> cellFactory = new Callback<TableColumn<HashMap, HashMap>, TableCell<HashMap, HashMap>>(){

            public TableCell<HashMap, HashMap> call(TableColumn<HashMap, HashMap> param) {
                TableCell<HashMap, HashMap> cell = new TableCell<HashMap, HashMap>(){
                    private final Hyperlink btn = new Hyperlink("Edit");
                    {
                        this.btn.setOnAction(e -> {
                            HashMap data = (HashMap)this.getTableView().getItems().get(this.getIndex());
                            AddShopItem.this.editEntry(data);
                        });
                    }

                    public void updateItem(HashMap item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            double requestedAmount = 0.0;
                            try {
                                requestedAmount = Double.parseDouble(item.get("quantity").toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.btn.setText(Config.formatNumber(requestedAmount));
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colFullStock.setCellFactory((Callback)cellFactory);
        this.colFullStock.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback confirmCellFactory = param -> new TableCell<BillOfMaterial, BillOfMaterial>(){
            private final Hyperlink editLink = new Hyperlink();
            {
                this.editLink.setOnAction(e -> this.handleEditAction());
            }

            protected void updateItem(BillOfMaterial item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                } else {
                    this.editLink.setText(Config.formatNumber(item.getQuantity()));
                    this.setGraphic((Node)this.editLink);
                }
            }

            private void handleEditAction() {
                BillOfMaterial data = (BillOfMaterial)this.getTableView().getItems().get(this.getIndex());
                if (data != null) {
                    TextInputDialog dialog = new TextInputDialog(data.getQuantity() + "");
                    dialog.setHeaderText(null);
                    dialog.setTitle("Edit Quantity");
                    dialog.setContentText("Enter new quantity:");
                    Optional result = dialog.showAndWait();
                    result.ifPresent(confirmedQty -> AddShopItem.this.editConfirmedQty(confirmedQty, data));
                }
            }
        };
        this.colCompositionQuantity.setCellFactory(confirmCellFactory);
        this.colCompositionQuantity.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback deleteCellFactory = param -> new TableCell<BillOfMaterial, BillOfMaterial>(){
            Button button = new Button();
            {
                this.button.setOnAction(e -> this.handleDeleteAction());
            }

            protected void updateItem(BillOfMaterial item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                } else {
                    this.button.setGraphic((Node)Config.getDeleteIcon());
                    this.button.getStyleClass().add((Object)"transparent_button");
                    this.setGraphic((Node)this.button);
                }
            }

            private void handleDeleteAction() {
                BillOfMaterial data = (BillOfMaterial)this.getTableView().getItems().get(this.getIndex());
                if (data != null && Config.showConfirmDialog("Remove Item", null, "Are you sure you want to remove " + data.getDescription() + " from the bill of materials?")) {
                    try {
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("id", data.getId());
                        params.put("itemCode", data.getItemCode());
                        String response = Config.loadDataFromPhp("masterdelete?type=bill_of_materials", params, AddShopItem.this.getUser());
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        if (jr.isStatus()) {
                            AddShopItem.this.allComposition.getItems().remove((Object)data);
                            AddShopItem.this.allComposition.refresh();
                        }
                        AddShopItem.this.notificationPane.setText(jr.getMessage());
                        AddShopItem.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        AddShopItem.this.notificationPane.show();
                    }
                    catch (Exception ignored) {
                        AddShopItem.this.notificationPane.setText("We encountered an error while processing your request");
                        AddShopItem.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        AddShopItem.this.notificationPane.show();
                    }
                }
            }
        };
        this.colCompositionRemove.setCellFactory(deleteCellFactory);
        this.colCompositionRemove.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.compositionSearchItem.setOnAction(e -> {
            try {
                if (((String)this.compositionItemType.getValue()).equalsIgnoreCase("Services")) {
                    Gson gson = new Gson();
                    String response = new Config().getObjectFromSelection("charge_item", gson.toJson((Object)this.compositionItem.getItems()), this.getUser());
                    this.compositionItem.setValue(gson.fromJson(response, ChargeItem.class));
                    this.compositionQuantity.requestFocus();
                } else {
                    Gson gson = new Gson();
                    String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.compositionItem.getItems()), this.getUser());
                    this.compositionItem.setValue(gson.fromJson(response, ShopItem.class));
                    this.compositionQuantity.requestFocus();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset");
        reset.setOnAction(event -> {
            this.photoJson = "";
            this.ivImage.setImage(new Image(this.holderImage));
            this.imagePath = null;
            this.imageName = null;
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        ContextMenu relationshipsMenu = new ContextMenu();
        MenuItem deleteRelationship = new MenuItem("Delete Relationship");
        deleteRelationship.setGraphic((Node)Config.getDeleteIcon());
        deleteRelationship.setOnAction(e -> {
            try {
                UnitOfMeasureRelationships relationship = (UnitOfMeasureRelationships)this.allRelationships.getSelectionModel().getSelectedItem();
                int tId = relationship.getId();
                String tProductCode = relationship.getItemCode();
                String tUomCode = relationship.getUnitOfMeasure().getId() + "";
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("id", tId);
                params.put("productCode", tProductCode);
                params.put("unitOfMeasureCode", tUomCode);
                String response = Config.loadDataFromPhp("masterdelete?type=unitofmeasurerelationship", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    this.loadUnitOfMeasureRelationships();
                }
            }
            catch (NullPointerException relationship) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while deleting the relationship. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        relationshipsMenu.getItems().add((Object)deleteRelationship);
        this.allRelationships.setContextMenu(relationshipsMenu);
        this.ivImage.setOnContextMenuRequested(event -> contextMenu.show((Node)this.ivImage, event.getScreenX(), event.getScreenY()));
        this.compositionItemType.setOnAction(e -> {
            String typeValue = (String)this.compositionItemType.getValue();
            if (typeValue.equalsIgnoreCase("Services")) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            AddShopItem.this.computationMethod.setDisable(false);
                            AddShopItem.this.notificationPane.setText("Loading Services. Please wait");
                            AddShopItem.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            AddShopItem.this.notificationPane.show();
                        });
                        ObservableList<ChargeItem> allChargeItems = new ChargeItem().getChargeItems(2, AddShopItem.this.getUser());
                        allChargeItems.sort(Comparator.comparing(ChargeItem::getName));
                        Platform.runLater(() -> {
                            AddShopItem.this.compositionItem.setItems(allChargeItems);
                            AddShopItem.this.notificationPane.hide();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            } else if (typeValue.equalsIgnoreCase("Items")) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            AddShopItem.this.notificationPane.setText("Loading Items. Please wait");
                            AddShopItem.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            AddShopItem.this.notificationPane.show();
                            AddShopItem.this.computationMethod.setValue(AddShopItem.this.computationMethod.getItems().get(0));
                            AddShopItem.this.computationMethod.setDisable(true);
                        });
                        ObservableList<ShopItem> allItems = new ShopItem().getAllItems(AddShopItem.this.getUser());
                        allItems.sort(Comparator.comparing(ShopItem::getName));
                        Platform.runLater(() -> {
                            AddShopItem.this.compositionItem.setItems(allItems);
                            AddShopItem.this.notificationPane.hide();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            }
        });
        this.addRelationShip.setOnAction(e -> {
            try {
                String message = "";
                boolean error = false;
                String tUnitOfMeasureCode = "";
                double tQuantity = 0.0;
                double tSellingPrice = 0.0;
                String tItemCode = "";
                try {
                    tUnitOfMeasureCode = ((UnitOfMeasure)this.relationshipUnitOfMeasure.getValue()).getId();
                }
                catch (Exception y) {
                    error = true;
                    message = "Please select the unit of measure";
                }
                try {
                    tQuantity = Double.parseDouble(this.relationshipQuantity.getText().trim());
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter the relationship quantity";
                }
                try {
                    tSellingPrice = Double.parseDouble(this.relationshipSellingPrice.getText().trim());
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter the relationship selling price";
                }
                try {
                    tItemCode = this.labelCode.getText().trim();
                    if (tItemCode.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Seems the item has not yet been created. Please create the item before creating the relationships";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("unitOfMeasureCode", tUnitOfMeasureCode);
                    params.put("quantity", tQuantity);
                    params.put("sellingPrice", tSellingPrice);
                    params.put("itemCode", tItemCode);
                    String response = Config.loadDataFromPhp("mastercreate?type=unitofmeasurerelationships", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadUnitOfMeasureRelationships();
                        this.relationshipUnitOfMeasure.getSelectionModel().select(0);
                        this.relationshipQuantity.setText("");
                        this.relationshipSellingPrice.setText("");
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while processing your request. Please try again ");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.addComposition.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("parent", this.labelCode.getText().trim());
            String itemType = ((String)this.compositionItemType.getValue()).trim();
            String compositionItemCode = "";
            compositionItemCode = itemType.equalsIgnoreCase("Services") ? ((ChargeItem)this.compositionItem.getValue()).getCode() + "" : ((ShopItem)this.compositionItem.getValue()).getCode().trim();
            String tComputationMethod = "";
            try {
                tComputationMethod = ((String)this.computationMethod.getValue()).trim();
            }
            catch (Exception ignored) {
                tComputationMethod = "";
            }
            params.put("compositionItem", compositionItemCode);
            params.put("compositionQuantity", this.compositionQuantity.getText().trim());
            params.put("itemType", itemType);
            params.put("computationMethod", tComputationMethod);
            String response = Config.loadDataFromPhp("mastercreate?type=add_product_composition", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.compositionItem.setValue(null);
                this.compositionQuantity.setText("");
                this.loadItemComposition();
            }
        });
        this.availableQuantity.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                final Stage stage = new Stage();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/itementries.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                ItemEntriesController controller = (ItemEntriesController)loader.getController();
                controller.setUser(this.user);
                controller.setSelectedItem(this.getItem());
                stage.setTitle("View Item Entries");
                stage.showAndWait();
            }
            catch (Exception p) {
                this.notificationPane.setText("We encountered an error while loading the item entries. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.addGroupSellingPrice.setOnAction(e -> {
            try {
                String message = "";
                boolean error = false;
                int tPricingGroup = 0;
                double tSellingPrice = 0.0;
                String tItemCode = "";
                try {
                    tItemCode = this.labelCode.getText().trim();
                    if (tItemCode.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception y) {
                    error = true;
                    message = "Please save the product first";
                }
                try {
                    tSellingPrice = Double.parseDouble(this.groupSellingPrice.getText().trim());
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter the selling price";
                }
                try {
                    tPricingGroup = ((PricingGroup)this.pricingGroup.getValue()).getId();
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the pricing group";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("pricingGroup", tPricingGroup);
                    params.put("sellingPrice", tSellingPrice);
                    params.put("itemCode", tItemCode);
                    String response = Config.loadDataFromPhp("mastercreate?type=product_price", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadPrices();
                        this.pricingGroup.getSelectionModel().select(0);
                        this.groupSellingPrice.setText("");
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while processing your request. Please try again ");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.sendToEtims.setOnAction(e -> {
            String tProductCode = this.labelCode.getText().trim();
            if (tProductCode.length() > 0) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("productCode", tProductCode);
                String response = Config.loadDataFromPhp("mastercreate?type=send_item_to_etims", params, this.getUser());
                System.out.println(response);
                this.notificationPane.setText(response);
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.show();
            } else {
                this.notificationPane.setText("Kindly update the product first");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
    }

    private void editEntry(HashMap data) {
        TextInputDialog alert = new TextInputDialog(data.get("quantity").toString());
        alert.setHeaderText("Edit Full Stock at " + data.get("location"));
        alert.setTitle("Edit Full Stock");
        Optional result = alert.showAndWait();
        result.ifPresent(quantity -> this.editFullStock((String)quantity, data));
    }

    private void editFullStock(String quantity, HashMap data) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("quantity", quantity);
        params.put("itemNo", data.get("itemNo").toString());
        params.put("locationId", data.get("locationId").toString());
        String response = Config.loadDataFromPhp("masterupdate?type=full_stock", params, this.getUser());
        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        if (jr.isStatus()) {
            data.put("quantity", quantity);
            this.fullStock.refresh();
        }
        this.notificationPane.setText(jr.getMessage());
        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
        this.notificationPane.show();
    }

    private void editConfirmedQty(String confirmedQty, BillOfMaterial data) {
        try {
            double quantity = Double.parseDouble(confirmedQty);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", data.getId());
            params.put("itemCode", data.getItemCode());
            params.put("quantity", quantity);
            params.put("type", "quantity");
            String response = Config.loadDataFromPhp("masterupdate?type=bill_of_materials", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                data.setQuantity(quantity);
                this.allComposition.refresh();
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
        }
        catch (NumberFormatException ignored) {
            this.notificationPane.setText("Invalid Quantity/Amount/percentage");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        catch (Exception ignored) {
            this.notificationPane.setText("We encountered an error while processing your request");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.apAddItem.getScene().getWindow();
        stage.fireEvent((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    private void saveItem(ActionEvent event) {
        this.save();
    }

    private void save() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String code = this.labelCode.getText().trim();
        if (code == null || code.equals("") || code.length() < 1) {
            code = "";
        }
        boolean error = false;
        String errorMessage = "";
        String name = "";
        String description = "";
        String taxGroup = "";
        String tDmsNo = "";
        double tBuyingPrice = 0.0;
        double sellingPrice = 0.0;
        double discount = 0.0;
        int brand = 0;
        String uom = "";
        int tReOrderLevel = 0;
        int postingGroup = 0;
        try {
            name = name + this.tfName.getText().trim();
            if (name.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Item name can not be empty!";
        }
        try {
            tBuyingPrice = Double.parseDouble(this.buyingPrice.getText().trim());
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Buying Item price can not be empty!";
        }
        try {
            sellingPrice = Double.parseDouble(this.tfPrice.getText().trim());
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Item price can not be empty!";
        }
        try {
            discount = Double.parseDouble(this.tfDiscount.getText().trim());
        }
        catch (Exception e) {
            discount = 0.0;
        }
        try {
            description = description + this.tfDescription.getText().trim();
            if (description.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Item description can not be empty!";
        }
        try {
            taxGroup = taxGroup + ((TaxGroup)this.cbTaxGroup.getSelectionModel().getSelectedItem()).getCode();
            if (taxGroup.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Select a valid tax group!";
        }
        try {
            brand = ((ItemBrand)this.cbBrand.getSelectionModel().getSelectedItem()).getId();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Select a valid brand!";
        }
        try {
            uom = ((UnitOfMeasure)this.cbUOM.getValue()).getId();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Unit of Measure cannot be empty!";
        }
        try {
            postingGroup = ((PostingGroup)this.cbPostingGroup.getValue()).getCode();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n" : "");
            errorMessage = errorMessage + "Select a valid posting group!";
        }
        try {
            tReOrderLevel = Integer.parseInt(this.reOrderLevel.getText().trim());
        }
        catch (Exception u) {
            tReOrderLevel = 0;
        }
        try {
            tDmsNo = this.dmsNo.getText().trim();
        }
        catch (Exception u) {
            // empty catch block
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
            return;
        }
        String upc = this.tfUPC.getText().trim();
        if (this.imagePath != null) {
            ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
            this.photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
        }
        String country = "";
        try {
            country = ((Countries)this.countryOfOrigin.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String itemClass = "";
        try {
            itemClass = ((ShopItem.ItemClassification)this.itemClassification.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String myItemType = "";
        try {
            myItemType = ((ShopItem.ItemType)this.itemType.getValue()).getCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String myPackaging = "";
        try {
            myPackaging = ((UnitOfMeasure)this.packagingUnit.getValue()).getId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            params.put("code", code);
            params.put("name", name);
            params.put("buyingPrice", tBuyingPrice);
            params.put("price", sellingPrice);
            params.put("discount", discount);
            params.put("description", description);
            params.put("taxGroup", taxGroup);
            params.put("brand", brand);
            params.put("postingGroup", postingGroup);
            params.put("uom", uom);
            params.put("photo", this.photoJson);
            params.put("imageName", this.imageName);
            params.put("upc", upc);
            params.put("reOrderLevel", tReOrderLevel);
            params.put("country", country);
            params.put("itemClass", itemClass);
            params.put("myItemType", myItemType);
            params.put("myPackaging", myPackaging);
            params.put("dmsNo", tDmsNo);
            String url = this.newProduct ? "mastercreate?type=item" : "masterupdate?type=item";
            new Config();
            String response = Config.loadDataFromPhp(url, params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                this.apAddItem.getScene().getWindow().hide();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
        catch (Exception u) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void setItem(final ShopItem item) {
        this.item = item;
        this.newProduct = false;
        try {
            this.labelCode.setText(item.getCode());
            this.tfName.setText(item.getName());
            this.tfPrice.setText(item.getPrice() + "");
            this.buyingPrice.setText(item.getBuyingPrice() + "");
            this.tfDescription.setText(item.getDescription());
            this.tfDiscount.setText(item.getDiscount() + "");
            this.cbBrand.getSelectionModel().select((Object)item.getBrand());
            this.cbTaxGroup.getSelectionModel().select((Object)item.getTaxGroup());
            this.cbUOM.getSelectionModel().select((Object)item.getUnitOfMeasure());
            this.cbPostingGroup.getSelectionModel().select((Object)item.getPostingGroup());
            this.tfUPC.setText(item.getUpcCode());
            this.reOrderLevel.setText(item.getReOrderLevel() + "");
            this.availableQuantity.setText(Config.formatNumber(item.getAvailable()));
            try {
                this.dmsNo.setText(item.getDmsNo());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadPrices();
            this.loadFullStock();
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    try {
                        String url = item.getPhotoUrl().length() < 1 ? AddShopItem.this.holderImage : item.getPhotoUrl();
                        Image image = new Image(url);
                        Platform.runLater(() -> {
                            AddShopItem.this.ivImage.setImage(image);
                            AddShopItem.this.notificationPane.hide();
                        });
                    }
                    catch (Exception u) {
                        u.printStackTrace();
                    }
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
            this.loadUnitOfMeasureRelationships();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadItemComposition();
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.ivImage.setImage(image);
            this.imagePath = file.getPath();
            this.imageName = file.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadUnitOfMeasureRelationships() {
        try {
            String tItemCode = this.labelCode.getText().trim();
            this.allRelationships.setItems(new UnitOfMeasureRelationships().getProductRelationships(tItemCode, this.getUser()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadPrices() {
        try {
            this.allPricingGroups.setItems(new ShopItem().getPrices(this.labelCode.getText().trim(), this.getUser()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadItemComposition() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddShopItem.this.materialsMasker.setVisible(true));
                ObservableList<BillOfMaterial> allItems = new BillOfMaterial().getAllMaterials(AddShopItem.this.labelCode.getText().trim(), AddShopItem.this.getUser());
                Platform.runLater(() -> {
                    AddShopItem.this.allComposition.setItems(allItems);
                    AddShopItem.this.materialsMasker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadFullStock() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddShopItem.this.fullStockMasker.setVisible(true));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("itemNo", AddShopItem.this.getItem().getCode());
                String response = Config.loadDataFromPhp("masterfetch?type=full_stock", params, AddShopItem.this.getUser());
                System.out.println(response);
                ObservableList myFullStock = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, HashMap[].class)));
                Platform.runLater(() -> {
                    AddShopItem.this.fullStock.setItems(myFullStock);
                    AddShopItem.this.fullStockMasker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadItemCompositionProducts() {
        System.out.println("Loading composition");
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("rawMaterials", 1);
                ObservableList<ShopItem> allItems = new ShopItem().getAllItems(params, AddShopItem.this.getUser());
                Platform.runLater(() -> AddShopItem.this.compositionItem.setItems(allItems));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

