/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddShopLocation
implements Initializable {
    private User user;
    @FXML
    private VBox vbShopLocation;
    @FXML
    private VBox vbHolder;
    @FXML
    private CheckBox vsm;
    @FXML
    private Label labelId;
    @FXML
    private TextField tfName;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;
    private ShopLocation location;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            ValidationSupport vs = new ValidationSupport();
            vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Required"));
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        });
    }

    @FXML
    private void saveShoplocation() {
        String name = this.tfName.getText().trim();
        Gson g = new Gson();
        if (name.length() < 1) {
            this.notificationPane.setText("Location name is required!");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", name);
            map.put("vsm", this.vsm.isSelected() ? 1 : 0);
            String id = this.labelId.getText().trim();
            if (id.length() != 0 || !id.equals("")) {
                map.put("id", id);
            }
            new Config();
            String response = Config.loadDataFromPhp("mastercreate?type=shoplocation", map, this.getUser());
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                this.vbShopLocation.getScene().getWindow().hide();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
    }

    @FXML
    private void cancel(ActionEvent actionEvent) {
        Stage stage = (Stage)this.vbShopLocation.getScene().getWindow();
        stage.fireEvent((Event)new WindowEvent((Window)stage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    public void setLocation(ShopLocation location) {
        this.location = location;
        if (location != null) {
            this.labelId.setText(String.valueOf(location.getId()));
            this.tfName.setText(location.getName());
            this.vsm.setSelected(location.isVsm());
        }
    }
}

