/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.ShopItem;
import classes.ShopLocation;
import classes.StockTransfer;
import classes.StockTransferLine;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class AddStockTransfer
implements Initializable {
    private User user;
    @FXML
    private VBox vbstockTransfer;
    @FXML
    private Button searchItem;
    @FXML
    private VBox vbHolder;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private Label labelCode;
    @FXML
    private JFXButton uploadLines;
    @FXML
    private DatePicker dpDate;
    @FXML
    private ComboBox<ShopItem> cbItem;
    @FXML
    private ComboBox<ShopLocation> cbFrom;
    @FXML
    private ComboBox<ShopLocation> cbTo;
    @FXML
    private TextField tfQuantity;
    @FXML
    private Button btnAddLine;
    @FXML
    private Button transferAll;
    @FXML
    private MaskerPane masker;
    @FXML
    private TableView<StockTransferLine> tvLines;
    @FXML
    private TableColumn tcItem;
    @FXML
    private TableColumn tcQuantity;
    @FXML
    private TableColumn tcRemove;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnPost;
    @FXML
    private Button btnReverse;
    private StockTransfer stockTransfer;
    private Gson g;
    private ObservableList<StockTransferLine> transferLines;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadItems();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    AddStockTransfer.this.notificationPane.setText("Loading Values. Please wait");
                    AddStockTransfer.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    AddStockTransfer.this.notificationPane.show();
                });
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(AddStockTransfer.this.getUser());
                Platform.runLater(() -> {
                    AddStockTransfer.this.cbFrom.setItems(allLocations);
                    AddStockTransfer.this.cbTo.setItems(allLocations);
                    AddStockTransfer.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadItems() {
        final Node original = this.searchItem.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddStockTransfer.this.searchItem.setGraphic((Node)Config.getLoader()));
                ObservableList<ShopItem> myItems = new ShopItem().getAllItems(AddStockTransfer.this.getUser());
                myItems.sort(Comparator.comparing(ShopItem::getName));
                Platform.runLater(() -> {
                    AddStockTransfer.this.cbItem.setItems(myItems);
                    AddStockTransfer.this.searchItem.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.masker.setVisible(false);
        PrefixSelectionCustomizer.customize(this.cbFrom);
        PrefixSelectionCustomizer.customize(this.cbTo);
        PrefixSelectionCustomizer.customize(this.cbItem);
        this.g = new Gson();
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        this.btnReverse.setDisable(true);
        this.tcItem.setCellValueFactory((Callback)new PropertyValueFactory("item"));
        Callback editCellFactory = param -> new TableCell<StockTransferLine, StockTransferLine>(){
            private final Hyperlink btn = new Hyperlink();
            {
                this.btn.setOnAction(e -> this.handleEditAction());
            }

            public void updateItem(StockTransferLine item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                } else {
                    this.btn.setText(Config.formatNumber(item.getQuantity()));
                    this.setGraphic((Node)this.btn);
                }
            }

            private void handleEditAction() {
                StockTransferLine data = (StockTransferLine)this.getTableView().getItems().get(this.getIndex());
                TextInputDialog alert = new TextInputDialog(data.getQuantity() + "");
                alert.setHeaderText(null);
                alert.setTitle("Edit Quantity");
                alert.setContentText("Edit Quantity");
                Optional result = alert.showAndWait();
                result.ifPresent(newQuantity -> AddStockTransfer.this.editQuantity(newQuantity, data));
            }
        };
        this.tcQuantity.setCellFactory(editCellFactory);
        this.tcQuantity.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback cellFactory = param -> new TableCell<StockTransferLine, StockTransferLine>(){
            private final Button btn = new Button();
            {
                this.btn.setOnAction(e -> this.handleDeleteAction());
            }

            public void updateItem(StockTransferLine item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setGraphic(null);
                } else {
                    this.btn.setGraphic((Node)Config.getDeleteIcon());
                    this.setGraphic((Node)this.btn);
                }
            }

            private void handleDeleteAction() {
                StockTransferLine data = (StockTransferLine)this.getTableView().getItems().get(this.getIndex());
                boolean confirmed = Config.showConfirmDialog("Delete Transfer Line", "The Transfer line will be permanently deleted", "Are you sure you want to remove the item " + data.getItem().toString() + " from this transfer?");
                if (!confirmed) {
                    return;
                }
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("id", data.getId());
                params.put("transferCode", AddStockTransfer.this.labelCode.getText().trim());
                String response = Config.loadDataFromPhp("masterdelete?type=stocktransferlines", params, AddStockTransfer.this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    AddStockTransfer.this.loadLines();
                }
                AddStockTransfer.this.notificationPane.setText(jr.getMessage());
                AddStockTransfer.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                AddStockTransfer.this.notificationPane.show();
            }
        };
        this.tcRemove.setCellFactory(cellFactory);
        this.tcRemove.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.dpDate.setValue((Object)LocalDate.now());
        Platform.runLater(() -> {
            if (this.stockTransfer != null) {
                this.cbFrom.getSelectionModel().select((Object)this.stockTransfer.getTransferFrom());
                this.cbTo.getSelectionModel().select((Object)this.stockTransfer.getTransferTo());
                this.loadLines();
                new Config();
                this.dpDate.setValue((Object)Config.stringToLocalDate(this.stockTransfer.getDateCreated()));
            }
        });
        this.searchItem.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.cbItem.getItems()), this.getUser());
                this.cbItem.setValue(gson.fromJson(response, ShopItem.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.transferAll.setOnAction(e -> {
            if (this.save()) {
                String transferNo = this.labelCode.getText();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("transferNo", transferNo);
                String response = Config.loadDataFromPhp("masterupdate?type=transfer_all", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadLines();
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        });
        this.uploadLines.setOnAction(e -> {
            if (this.save()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileChooser chooser = new FileChooser();
                        chooser.setTitle("Select Excel to Import Entries From");
                        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                        try {
                            File file = chooser.showOpenDialog((Window)new Stage());
                            if (file != null) {
                                final XSSFWorkbook wb = new XSSFWorkbook(file);
                                final XSSFSheet ws = wb.getSheetAt(0);
                                Task<Void> task1 = new Task<Void>(){

                                    public Void call() {
                                        int noOfRecords = ws.getPhysicalNumberOfRows();
                                        Platform.runLater(() -> {
                                            AddStockTransfer.this.notificationPane.setText("Importing Entries Please wait");
                                            AddStockTransfer.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                                            AddStockTransfer.this.notificationPane.show();
                                        });
                                        for (int b = 1; b < noOfRecords; ++b) {
                                            int c = b;
                                            this.updateProgress(c + 1, noOfRecords);
                                            Platform.runLater(() -> AddStockTransfer.this.notificationPane.setText("Uploading Records. Please wait... " + (c + 1) + " of " + noOfRecords));
                                            XSSFRow myRow = ws.getRow(b);
                                            try {
                                                Cell myCell;
                                                String itemNo = "";
                                                double tUnitPrice = 0.0;
                                                double tQuantity = 0.0;
                                                try {
                                                    myCell = myRow.getCell(0);
                                                    itemNo = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    itemNo = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(1);
                                                    tUnitPrice = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tUnitPrice = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(2);
                                                    tQuantity = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tQuantity = 0.0;
                                                }
                                                if (!(tQuantity > 0.0)) continue;
                                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                                params.put("transferCode", AddStockTransfer.this.labelCode.getText());
                                                params.put("item", itemNo);
                                                params.put("quantity", tQuantity);
                                                params.put("unitPrice", tUnitPrice);
                                                String response = Config.loadDataFromPhp("mastercreate?type=stocktransferline", params, AddStockTransfer.this.getUser());
                                                System.out.println(response);
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        AddStockTransfer.this.loadLines();
                                        try {
                                            wb.close();
                                        }
                                        catch (Exception y) {
                                            y.printStackTrace();
                                        }
                                        Platform.runLater(() -> AddStockTransfer.this.notificationPane.hide());
                                        return null;
                                    }
                                };
                                Thread backgroundThread = new Thread((Runnable)task1);
                                backgroundThread.setDaemon(true);
                                backgroundThread.start();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    private void editQuantity(String newQuantity, StockTransferLine data) {
        try {
            double myQuantity = Double.parseDouble(newQuantity.trim());
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("quantity", myQuantity);
            params.put("transferCode", this.labelCode.getText().trim());
            params.put("id", data.getRemove());
            String response = Config.loadDataFromPhp("masterupdate?type=stocktransferlines", params, this.getUser());
            Gson g = new Gson();
            JsonResponses js = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (js.isStatus()) {
                data.setQuantity(myQuantity);
                this.tvLines.refresh();
            }
            this.notificationPane.setText(js.getMessage());
            this.notificationPane.setGraphic((Node)js.getIconFromStatus());
            this.notificationPane.show();
        }
        catch (NumberFormatException u) {
            this.notificationPane.setText("Please enter a valid quantity");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
        catch (Exception u) {
            this.notificationPane.setText("We experienced an error while editing the quantity. Please try again later. ");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    @FXML
    void addLine(ActionEvent event) {
        ShopItem item = null;
        boolean error = false;
        String errorMessage = "";
        double q = Double.parseDouble(this.tfQuantity.getText().trim());
        if (this.labelCode.getText().equals("") && !this.save()) {
            return;
        }
        String code = this.labelCode.getText();
        try {
            item = (ShopItem)this.cbItem.getValue();
            if (item == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Select an item for sale!";
        }
        if (!error) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("item", item.getCode());
            params.put("quantity", q);
            params.put("transferCode", code);
            params.put("unitPrice", item.getBuyingPrice());
            new Config();
            String response = Config.loadDataFromPhp("mastercreate?type=stocktransferline", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.loadLines();
            }
        } else {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
            return;
        }
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbstockTransfer.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void postTransfer(ActionEvent event) {
        if (this.save()) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("code", this.labelCode.getText().trim());
            new Config();
            String response = Config.loadDataFromPhp("masterpost?type=stocktransfer", params, this.getUser());
            System.out.println(response);
            JsonResponses jsonResponses = (JsonResponses)this.g.fromJson(response, JsonResponses.class);
            if (jsonResponses.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jsonResponses.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jsonResponses.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.vbstockTransfer.getScene().getWindow();
                stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
            } else {
                this.notificationPane.setText(jsonResponses.getMessage());
                this.notificationPane.setGraphic((Node)jsonResponses.getIconFromStatus());
                this.notificationPane.show();
            }
        }
    }

    @FXML
    void reverseTransfer(ActionEvent event) {
    }

    @FXML
    void saveTransfer(ActionEvent event) {
        this.save();
    }

    private boolean save() {
        boolean error = false;
        String errorMessage = "";
        String code = this.labelCode.getText().trim();
        NumberSeries ns = null;
        if (code == null || code.equals("")) {
            ns = new NumberSeries(42, this.getUser());
            code = ns.getNextNumber();
        }
        String date = "";
        ShopLocation from = null;
        ShopLocation to = null;
        try {
            new Config();
            date = Config.localDateToString((LocalDate)this.dpDate.getValue());
            if (date.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Enter a valid date";
        }
        try {
            from = (ShopLocation)this.cbFrom.getValue();
            if (from == null) {
                throw new Exception("Enter a valid from location");
            }
            to = (ShopLocation)this.cbTo.getValue();
            if (to == null) {
                throw new Exception("Enter a valid to location");
            }
            if (from.equals(to) || from.getId() == to.getId()) {
                throw new Exception("Locations must not be the same");
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + (errorMessage.length() > 1 ? "\n " + e.getMessage() : e.getMessage());
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
            return false;
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("code", code);
        params.put("dateCreated", date);
        params.put("transferFrom", from.getId());
        params.put("transferTo", to.getId());
        new Config();
        String response = Config.loadDataFromPhp("mastercreate?type=stocktransfer", params, this.getUser());
        System.out.println(response);
        JsonResponses res = (JsonResponses)this.g.fromJson(response, JsonResponses.class);
        if (res.isStatus()) {
            if (this.labelCode.getText().trim().equals("")) {
                ns.updateLastUsed(code);
            }
            this.labelCode.setText(code);
            return true;
        }
        this.notificationPane.setText(res.getMessage());
        this.notificationPane.setGraphic((Node)res.getIconFromStatus());
        this.notificationPane.show();
        return false;
    }

    public void setStockTransfer(StockTransfer stockTransfer) {
        this.stockTransfer = stockTransfer;
        this.labelCode.setText(stockTransfer.getCode());
        if (stockTransfer.isPosted()) {
            this.btnPost.setDisable(true);
            this.btnSave.setDisable(true);
        }
    }

    public void loadLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AddStockTransfer.this.masker.setVisible(true));
                AddStockTransfer.this.transferLines = new StockTransferLine().getAllLines(AddStockTransfer.this.labelCode.getText().trim(), AddStockTransfer.this.getUser());
                Platform.runLater(() -> {
                    AddStockTransfer.this.tvLines.setItems(AddStockTransfer.this.transferLines);
                    AddStockTransfer.this.masker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

