/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.TaxGroup;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddTaxGroup
implements Initializable {
    private User user;
    @FXML
    private VBox vbTaxGroup;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelCode;
    @FXML
    private TextField tfName;
    @FXML
    private TextField tfPercentage;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;
    private TaxGroup taxGroup;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            ValidationSupport vs = new ValidationSupport();
            vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Required"));
            vs.registerValidator((Control)this.tfPercentage, Validator.createEmptyValidator((String)"Required"));
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        });
    }

    @FXML
    private void cancel(ActionEvent event) {
        this.vbTaxGroup.getScene().getWindow().hide();
    }

    @FXML
    private void saveTaxGroup(ActionEvent event) {
        this.save();
    }

    private void save() {
        String name = this.tfName.getText().trim();
        String percentage = this.tfPercentage.getText().trim();
        Gson g = new Gson();
        if (name.length() < 1) {
            this.notificationPane.setText("Tax group name is required!");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", name);
            map.put("percentage", percentage.length() < 1 ? Double.valueOf(0.0) : percentage);
            String code = this.labelCode.getText().trim();
            NumberSeries numberSeries = new NumberSeries(40, this.getUser());
            if (code.length() != 0 || !code.equals("")) {
                map.put("code", code);
            } else {
                map.put("code", numberSeries.getNextNumber());
            }
            System.out.println(map);
            new Config();
            String response = Config.loadDataFromPhp("mastercreate?type=taxgroup", map, this.getUser());
            System.out.print(response);
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.vbTaxGroup.getScene().getWindow().hide();
                if (this.labelCode.getText() == null || this.labelCode.getText().equals("")) {
                    numberSeries.updateLastUsed(numberSeries.getNextNumber());
                }
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        }
    }

    public void setTaxGroup(TaxGroup taxGroup) {
        this.taxGroup = taxGroup;
        this.labelCode.setText(taxGroup.getCode());
        this.tfName.setText(taxGroup.getName());
        this.tfPercentage.setText(String.valueOf(taxGroup.getPercentage()));
    }
}

