/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Town;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddTownController
implements Initializable {
    private User user;
    @FXML
    Label townId;
    @FXML
    NotificationPane notificationPane;
    @FXML
    AnchorPane holder;
    @FXML
    private TextField townName;
    @FXML
    private ComboBox<Vendor> county;
    @FXML
    private TextField parkingFeeCounty;
    @FXML
    private TextField parkingFeeSacco;
    @FXML
    private JFXButton addTown;
    @FXML
    private JFXButton reset;
    private Town town;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Town getTown() {
        return this.town;
    }

    public void setTown(Town town) {
        this.town = town;
        this.townName.setText(town.getTownName());
        this.county.setValue((Object)town.getCounty());
        this.parkingFeeCounty.setText(town.getCountyParkingFee() + "");
        this.parkingFeeSacco.setText(town.getSaccoParkingFee() + "");
        this.townId.setText(town.getTownId() + "");
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.county.setItems(new Vendor().getAllVendors(this.getUser()));
        this.addTown.setOnAction(e -> {
            boolean error = false;
            String message = "";
            String sTownName = this.townName.getText().trim();
            String tCountyCode = "";
            double tParkingFeeCounty = 0.0;
            double tParkingFeeSacco = 0.0;
            if (sTownName.length() == 0) {
                message = "Please enter town name";
                error = true;
            }
            try {
                tCountyCode = ((Vendor)this.county.getValue()).getVendorNumber();
                if (tCountyCode.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception r) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the county";
                error = true;
            }
            try {
                tParkingFeeCounty = Double.parseDouble(this.parkingFeeCounty.getText().trim());
            }
            catch (Exception t) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid value for monthly parking fee (county)";
                error = true;
            }
            try {
                tParkingFeeSacco = Double.parseDouble(this.parkingFeeSacco.getText().trim());
            }
            catch (Exception t) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid value for monthly parking fee (sacco)";
                error = true;
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                try {
                    int townCode = Integer.parseInt(this.townId.getText().trim());
                    if (townCode > 0) {
                        params.put("townCode", townCode);
                    }
                }
                catch (Exception townCode) {
                    // empty catch block
                }
                params.put("townName", sTownName);
                params.put("countyCode", tCountyCode);
                params.put("parkingFeeCounty", tParkingFeeCounty);
                params.put("parkingFeeSacco", tParkingFeeSacco);
                String response = Config.loadDataFromPhp("mastercreate?type=town", params, this.getUser());
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)Config.getCheckIcon());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.addTown.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
            }
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.townName, Validator.createEmptyValidator((String)"Town name is required"));
        vs.registerValidator(this.county, Validator.createEmptyValidator((String)"County is required"));
        vs.registerValidator((Control)this.parkingFeeCounty, Validator.createEmptyValidator((String)"Monthly Parking Fee (County) is required"));
        vs.registerValidator((Control)this.parkingFeeSacco, Validator.createEmptyValidator((String)"Monthly Parking Fee (Sacco) is required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.parkingFeeSacco = new Config().setDoubleTextField(this.parkingFeeSacco);
        this.parkingFeeCounty = new Config().setDoubleTextField(this.parkingFeeCounty);
    }
}

