/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.Employee;
import classes.JsonResponses;
import classes.PricingGroup;
import classes.ShopLocation;
import classes.User;
import classes.UserRoles;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddUserController
implements Initializable {
    private User user;
    @FXML
    private VBox holder;
    @FXML
    private TextField userName;
    @FXML
    private TextField fullName;
    @FXML
    private TextField emailAddress;
    @FXML
    private JFXButton addUser;
    @FXML
    private JFXButton reset;
    @FXML
    private TextField phoneNumber;
    @FXML
    private PasswordField password;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private ComboBox<UserRoles> userRole;
    @FXML
    private ComboBox<Employee> employeeAccount;
    @FXML
    private ComboBox<ShopLocation> warehouse;
    @FXML
    private ComboBox<PricingGroup> pricingGroup;
    @FXML
    private ComboBox<Customer> receivablesAccount;
    @FXML
    private ComboBox<Bank> defaultBank;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    AddUserController.this.notificationPane.setText("Loading Values. Please wait");
                    AddUserController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    AddUserController.this.notificationPane.show();
                });
                ObservableList<UserRoles> allRoles = new UserRoles().getAllRoles(user);
                ObservableList<Employee> allEmployee = new Employee().getAllEmployees(user);
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(user);
                ObservableList<PricingGroup> allGroups = new PricingGroup().getPricingGroups(user);
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(user);
                ObservableList<Bank> allBanks = Bank.getAllBanks(user);
                Platform.runLater(() -> {
                    AddUserController.this.warehouse.setItems(allLocations);
                    AddUserController.this.userRole.setItems(allRoles);
                    AddUserController.this.employeeAccount.setItems(allEmployee);
                    AddUserController.this.pricingGroup.setItems(allGroups);
                    try {
                        AddUserController.this.pricingGroup.setValue(AddUserController.this.pricingGroup.getItems().get(0));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    AddUserController.this.receivablesAccount.setItems(allCustomers);
                    AddUserController.this.defaultBank.setItems(allBanks);
                    AddUserController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.userName, Validator.createEmptyValidator((String)"Username is required"));
        vs.registerValidator((Control)this.fullName, Validator.createEmptyValidator((String)"Full Name is required"));
        vs.registerValidator(this.userRole, Validator.createEmptyValidator((String)"User role is required"));
        vs.registerValidator((Control)this.password, Validator.createEmptyValidator((String)"Password is required"));
        this.addUser.setOnAction(e -> {
            int tBank;
            String tCustomerAccount;
            int tPricingGroup;
            int tWarehouse;
            String tEmployeeCode;
            String message = "";
            boolean error = false;
            String tUserName = this.userName.getText().trim();
            int tRoleId = 0;
            try {
                if (tUserName.equals("")) {
                    error = true;
                    message = "Username is mandatory. ";
                } else if (tUserName.length() < 4) {
                    error = true;
                    message = message + "Username must be a minimum of 4 characters. ";
                }
            }
            catch (NullPointerException t) {
                error = true;
                message = "Username is mandatory. ";
            }
            String tFullName = this.fullName.getText().trim();
            try {
                if (tFullName.equals("")) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Full Name is mandatory. ";
                }
            }
            catch (NullPointerException t) {
                error = true;
                message = message + "Full Name is mandatory. ";
            }
            String tPassword = this.password.getText().trim();
            try {
                if (tPassword.equals("")) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Password is mandatory. ";
                } else if (tPassword.length() < 4) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Password must be a minimum of 4 characters. ";
                }
            }
            catch (NullPointerException t) {
                error = true;
                message = message + "Password is mandatory. ";
            }
            try {
                tRoleId = ((UserRoles)this.userRole.getValue()).getId();
            }
            catch (Exception t) {
                error = true;
                message = message + "User role is mandatory. ";
            }
            try {
                tEmployeeCode = ((Employee)this.employeeAccount.getValue()).getEmployeeNumber();
            }
            catch (Exception u) {
                tEmployeeCode = "";
            }
            try {
                tWarehouse = ((ShopLocation)this.warehouse.getValue()).getId();
            }
            catch (Exception u) {
                tWarehouse = 0;
            }
            try {
                tPricingGroup = ((PricingGroup)this.pricingGroup.getValue()).getId();
            }
            catch (Exception u) {
                tPricingGroup = 0;
            }
            try {
                tCustomerAccount = ((Customer)this.receivablesAccount.getValue()).getCustomerNumber();
            }
            catch (Exception u) {
                tCustomerAccount = "";
            }
            try {
                tBank = ((Bank)this.defaultBank.getValue()).getCode();
            }
            catch (Exception ignored) {
                tBank = 0;
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    String tPhoneNumber = this.phoneNumber.getText().trim();
                    String tEmailAddress = this.emailAddress.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("userName", tUserName);
                    params.put("fullName", tFullName);
                    params.put("emailAddress", tEmailAddress);
                    params.put("phoneNumber", tPhoneNumber);
                    params.put("roleId", tRoleId);
                    params.put("employeeCode", tEmployeeCode);
                    params.put("warehouse", tWarehouse);
                    params.put("customerAccount", tCustomerAccount);
                    params.put("pricingGroup", tPricingGroup);
                    params.put("bank", tBank);
                    params.put("password", tPassword);
                    String response = Config.loadDataFromPhp("mastercreate?type=adduser", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.userName.setText("");
                        this.fullName.setText("");
                        this.phoneNumber.setText("");
                        this.emailAddress.setText("");
                        this.password.setText("");
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception t) {
                    this.notificationPane.setText("We experienced an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }
}

