/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.LeaveBalance;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AdjustLeaveDaysController
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private ComboBox<Employee> employee;
    @FXML
    private JFXButton searchEmployee;
    @FXML
    private TextField noOfDays;
    @FXML
    private TextField description;
    @FXML
    private Button post;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Platform.runLater(() -> this.employee.setItems(new Employee().getAllEmployees(user)));
        this.post.setDisable(false);
    }

    public void setBalance(LeaveBalance leaveBalance) {
        this.employee.setValue((Object)leaveBalance.getEmployee());
        this.noOfDays.setText(leaveBalance.getBalance() + "");
        this.description.setText(leaveBalance.getDescription());
        this.post.setDisable(true);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.employee, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.noOfDays, Validator.createEmptyValidator((String)"Required"));
        this.noOfDays = new Config().setDoubleTextField(this.noOfDays);
        this.searchEmployee.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("employee", this.getUser());
                Employee selected = (Employee)new Gson().fromJson(response, Employee.class);
                String employeeNo = selected.getEmployeeNumber();
                this.employee.setValue((Object)selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.post.setOnAction(e -> {
            try {
                String message = "";
                boolean error = false;
                String employeeNo = "";
                String tDescription = "";
                double tDays = 0.0;
                try {
                    employeeNo = ((Employee)this.employee.getValue()).getEmployeeNumber();
                }
                catch (Exception yu) {
                    error = true;
                    message = "Please select the employee";
                }
                try {
                    tDescription = this.description.getText().trim();
                    if (tDescription.length() == 0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter the adjustment description";
                }
                try {
                    tDays = Double.parseDouble(this.noOfDays.getText().trim());
                    if (tDays == 0.0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please enter a valid number of days";
                }
                if (error) {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                } else {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("employeeNo", employeeNo);
                    params.put("description", tDescription);
                    params.put("days", tDays);
                    String response = Config.loadDataFromPhp("masterpost?type=adjustleavedays", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        GeneralListController.publicNotificationPane.setText(jr.getMessage());
                        GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                        GeneralListController.publicNotificationPane.show();
                        Stage stage = (Stage)this.post.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setText(jr.getMessage());
                        this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                        this.notificationPane.show();
                    }
                }
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }
}

