/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.addAssetController;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class AllAssetsController
implements Initializable {
    private User user;
    @FXML
    private VBox root;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane details;
    @FXML
    private JFXButton addAsset;
    @FXML
    private JFXButton editAsset;
    @FXML
    private JFXButton deleteAsset;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton memberStatement;
    @FXML
    private JFXButton allMembers;
    @FXML
    private TableView<FixedAssets> allAssetsTable;
    @FXML
    private TableColumn assetNo;
    @FXML
    private TableColumn assetSerial;
    @FXML
    private TableColumn description;
    @FXML
    private TableColumn dateAcquired;
    @FXML
    private TableColumn bookValue;
    @FXML
    private TableColumn assignedTo;
    @FXML
    private TableColumn location;
    @FXML
    private MaskerPane masker;
    @FXML
    private HBox searchBox;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private AnchorPane preview;
    @FXML
    private AnchorPane previewMember;
    @FXML
    private ImageView previewProfilePhoto;
    @FXML
    private Label previewName;
    @FXML
    private Label previewIdNumber;
    @FXML
    private Label previewphoneNumber;
    @FXML
    private Label previewEmailAddress;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadItems();
    }

    public void refreshTable() {
    }

    public void loadItems() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            ObservableList<FixedAssets> allAssets = new FixedAssets().getAllAssets(this.getUser());
            this.allAssetsTable.setItems(allAssets);
            this.masker.setVisible(false);
            this.allAssetsTable.getSelectionModel().select(0);
        });
    }

    public void initialize(URL location1, ResourceBundle resources) {
        this.assetNo.setCellValueFactory((Callback)new PropertyValueFactory("assetNo"));
        this.assetSerial.setCellValueFactory((Callback)new PropertyValueFactory("assetSerial"));
        this.description.setCellValueFactory((Callback)new PropertyValueFactory("assetName"));
        this.dateAcquired.setCellValueFactory((Callback)new PropertyValueFactory("dateAcquired"));
        this.bookValue.setCellValueFactory((Callback)new PropertyValueFactory("bookValueString"));
        this.location.setCellValueFactory((Callback)new PropertyValueFactory("Location"));
        this.assignedTo.setCellValueFactory((Callback)new PropertyValueFactory("assignedTo"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.addAsset.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/addAsset.fxml").openStream());
                addAssetController controller = (addAssetController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        KeyCode key = event.getCode();
                        if (key == KeyCode.ESCAPE || key == KeyCode.CAPS) {
                            stage.close();
                            AllAssetsController.this.loadItems();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Asset");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllAssetsController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
        this.allAssetsTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    FixedAssets rowData = (FixedAssets)row.getItem();
                    FixedAssets fixedAssets = (FixedAssets)this.allAssetsTable.getSelectionModel().getSelectedItem();
                    if (!fixedAssets.equals(null)) {
                        try {
                            this.editAsset(fixedAssets);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            return row;
        });
        this.editAsset.setOnAction(e -> {
            try {
                FixedAssets fa = (FixedAssets)this.allAssetsTable.getSelectionModel().getSelectedItem();
                if (!fa.equals(null) && !fa.getAssetNo().equals("")) {
                    this.editAsset(fa);
                }
            }
            catch (NullPointerException fa) {
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
        this.deleteAsset.setOnAction(e -> {
            try {
                FixedAssets m = (FixedAssets)this.allAssetsTable.getSelectionModel().getSelectedItem();
                String path = System.getProperty("user.dir");
                path = path.replace("\\", "/");
                String fileLocation = path + "/loading.gif";
                File file = new File(fileLocation);
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("assetNo", m.assetNo);
                String response2 = Config.loadDataFromPhp("masterdelete?type=fixedasset", params, this.getUser());
                Gson g = new Gson();
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.loadItems();
                } else {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Could not delete");
                    alert.setHeaderText("The asset could not be deleted");
                    alert.setContentText(myResponse.getMessage());
                    alert.showAndWait();
                }
            }
            catch (Exception t) {
                t.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Could not delete");
                alert.setHeaderText("We encountered an error while deleting the asset. Please try again later");
                alert.showAndWait();
            }
        });
    }

    private void editAsset(FixedAssets fa) throws IOException {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/addAsset.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            addAssetController controller = (addAssetController)loader.getController();
            controller.setUser(this.getUser());
            controller.setAsset(fa);
            stage.setTitle("Edit Asset");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllAssetsController.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit fixed asset screen. Please contact support");
            alert.showAndWait();
        }
    }
}

