/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Investment;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AddInvestmentController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class AllInvestmentsController
implements Initializable {
    private User user;
    @FXML
    private StackPane stackpane;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox root;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane details;
    @FXML
    private JFXButton addInvestment;
    @FXML
    private JFXButton editInvestment;
    @FXML
    private JFXButton deleteInvestment;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton investmentInfo;
    @FXML
    private JFXButton allInvestments;
    @FXML
    private TableView<Investment> allInvestmentsTable;
    @FXML
    private TableColumn investmentNo;
    @FXML
    private TableColumn investmentName;
    @FXML
    private TableColumn description;
    @FXML
    private TableColumn startDate;
    @FXML
    private TableColumn value;
    @FXML
    private MaskerPane masker;
    @FXML
    private HBox searchBox;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;
    private Investment investment;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Investment getInvestment() {
        return this.investment;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadItems();
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackpane);
        this.investmentNo.setCellValueFactory((Callback)new PropertyValueFactory("investmentNo"));
        this.description.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.startDate.setCellValueFactory((Callback)new PropertyValueFactory("startDate"));
        this.value.setCellValueFactory((Callback)new PropertyValueFactory("valueString"));
        this.investmentName.setCellValueFactory((Callback)new PropertyValueFactory("investmentName"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.deleteInvestment.setOnAction(e -> {
            try {
                Investment delete = (Investment)this.allInvestmentsTable.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("investmentNumber", delete.getInvestmentNo());
                String response2 = Config.loadDataFromPhp("masterdelete?type=deleteInvestment", params, this.getUser());
                Gson g = new Gson();
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                this.notificationPane.show();
                if (myResponse.isStatus()) {
                    this.loadItems();
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.addInvestment.setOnAction(e -> {
            Parent root = null;
            try {
                root = (Parent)FXMLLoader.load((URL)this.getClass().getResource("/fxml/addInvestment.fxml"));
                Scene scene = new Scene(root, 422.0, 366.0);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        KeyCode key = event.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Investment");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllInvestmentsController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
        this.allInvestmentsTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Investment rowData = (Investment)row.getItem();
                    Investment investment = (Investment)this.allInvestmentsTable.getSelectionModel().getSelectedItem();
                    if (!investment.equals(null)) {
                        this.editInvestment(investment);
                    }
                }
            });
            return row;
        });
        this.allInvestmentsTable.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.editInvestment.setDisable(false);
            }
        });
        this.editInvestment.setOnAction(r -> {
            try {
                Investment investment = (Investment)this.allInvestmentsTable.getSelectionModel().getSelectedItem();
                if (!investment.equals(null) && !investment.getInvestmentNo().equals("")) {
                    this.editInvestment(investment);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void editInvestment(Investment mInvestment) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/addInvestment.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane, 422.0, 366.0);
            final Stage editInvestmentStage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        editInvestmentStage.close();
                    }
                }
            });
            editInvestmentStage.setScene(editMember);
            AddInvestmentController controller = (AddInvestmentController)loader.getController();
            controller.setInvestment(mInvestment);
            editInvestmentStage.setTitle("Edit Investment");
            editInvestmentStage.setResizable(false);
            try {
                editInvestmentStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            editInvestmentStage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllInvestmentsController.this.loadItems();
                        }
                    });
                }
            });
            editInvestmentStage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your Investments screen. Please contact support");
            alert.showAndWait();
        }
    }

    private void loadItems() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            ObservableList<Investment> allInvestmentsList = new Investment().getAllInvestments(this.getUser());
            this.allInvestmentsTable.setItems(allInvestmentsList);
            this.allInvestmentsTable.getSelectionModel().select(0);
            this.masker.setVisible(false);
        });
    }
}

