/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Loan;
import classes.Member;
import classes.MemberImport;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AddMemberController;
import controllers.ConfirmMemberImport;
import controllers.EditMemberController;
import controllers.NextOfKinController;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import sun.misc.BASE64Decoder;

public class AllMembersController
implements Initializable {
    private User user;
    Map<String, Object> params = new LinkedHashMap<String, Object>();
    ObservableList<Member> myMembers = FXCollections.observableArrayList();
    @FXML
    private JFXButton addMember;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton excelImport;
    @FXML
    private JFXButton nextOfKin;
    @FXML
    private JFXButton editMember;
    @FXML
    private JFXButton memberStatement;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton allMembers;
    @FXML
    private JFXButton membersMonthly;
    @FXML
    private JFXButton memberMonthlyStatement;
    @FXML
    private AnchorPane previewMember;
    @FXML
    private TableView<Member> allMembersTable;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private StackPane stackpane;
    @FXML
    private TableColumn memberNo;
    @FXML
    private TableColumn memberName;
    @FXML
    private TableColumn memberIdNo;
    @FXML
    private TableColumn memberPhoneNo;
    @FXML
    private TableColumn memberEmail;
    @FXML
    private TableColumn memberShares;
    @FXML
    private TableColumn memberSavings;
    @FXML
    private TableColumn memberContributions;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;
    @FXML
    MaskerPane masker;
    @FXML
    private Label previewName;
    @FXML
    private Label previewIdNumber;
    @FXML
    private Label previewphoneNumber;
    @FXML
    private Label previewEmailAddress;
    @FXML
    private TableView<Loan> previewLoans;
    @FXML
    private TableColumn previewLoanNumber;
    @FXML
    private TableColumn previewLoanBalance;
    @FXML
    private TableView<?> previewMiniStatement;
    @FXML
    private TableColumn<?, ?> previewdate;
    @FXML
    private TableColumn<?, ?> previewTransaction;
    @FXML
    ImageView previewProfilePhoto;
    @FXML
    private TableColumn<?, ?> previewAmount;
    public static Stage editMemberStage = new Stage();
    public static Stage confirmImport = new Stage();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
        this.loadItems();
    }

    @FXML
    public void onEnter(ActionEvent ae) {
        String searchString = this.searchBar.getText().trim().toLowerCase();
        ObservableList allMembers = FXCollections.observableArrayList();
        for (int b = 0; b < this.myMembers.size(); ++b) {
            Member current = (Member)this.myMembers.get(b);
            String myId = current.getIdNumber() + "";
            if (!current.getFullName().toLowerCase().contains(searchString) && !current.getMemberNumber().toLowerCase().contains(searchString) && !myId.toLowerCase().contains(searchString)) continue;
            allMembers.add((Object)current);
        }
        this.allMembersTable.getItems().removeAll((Collection)this.allMembersTable.getItems());
        this.allMembersTable.setItems(allMembers);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.stackpane);
        this.memberNo.setCellValueFactory((Callback)new PropertyValueFactory("memberNumber"));
        this.memberName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.memberIdNo.setCellValueFactory((Callback)new PropertyValueFactory("idNumber"));
        this.memberPhoneNo.setCellValueFactory((Callback)new PropertyValueFactory("PhoneNumber"));
        this.memberEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.memberShares.setCellValueFactory((Callback)new PropertyValueFactory("shareCapitalString"));
        this.memberContributions.setCellValueFactory((Callback)new PropertyValueFactory("contributionsString"));
        this.memberSavings.setCellValueFactory((Callback)new PropertyValueFactory("savingsString"));
        this.previewLoanNumber.setCellValueFactory((Callback)new PropertyValueFactory("loanLink"));
        this.previewLoanBalance.setCellValueFactory((Callback)new PropertyValueFactory("loanBalanceString"));
        this.membersMonthly.setOnAction(e -> new Member().getAllMembersMonthlyStatement(this.getUser()));
        this.nextOfKin.setOnAction(e -> {
            try {
                Member member = (Member)this.allMembersTable.getSelectionModel().getSelectedItem();
                member.getMemberNumber();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/nextofkin.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane, 1000.0, 387.0);
                final Stage stage = new Stage();
                stage.initModality(Modality.APPLICATION_MODAL);
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                NextOfKinController controller = (NextOfKinController)loader.getController();
                controller.setUser(this.getUser());
                controller.setMember(member);
                stage.setTitle("Member next of Kin");
                stage.setResizable(true);
                stage.show();
            }
            catch (NullPointerException p) {
                this.notificationPane.setText("Please select a member to view their next of kin");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
            catch (Exception p) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.memberMonthlyStatement.setOnAction(e -> {
            try {
                Member member = (Member)this.allMembersTable.getSelectionModel().getSelectedItem();
                member.getMemberMonthlyStatement(this.getUser());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.excelImport.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                block25: {
                    FileChooser chooser = new FileChooser();
                    chooser.setTitle("Select Excel to Import Members from");
                    chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                    try {
                        File file = chooser.showOpenDialog((Window)new Stage());
                        if (file == null) break block25;
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        XSSFSheet ws = wb.getSheetAt(0);
                        ObservableList toImport = FXCollections.observableArrayList();
                        for (int a = 1; a < ws.getPhysicalNumberOfRows(); ++a) {
                            XSSFRow myRow = ws.getRow(a);
                            try {
                                Cell myCell;
                                MemberImport myImport = new MemberImport();
                                try {
                                    myCell = myRow.getCell(0);
                                    myImport.setMemberNo(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMemberNo("");
                                }
                                try {
                                    myCell = myRow.getCell(1);
                                    myImport.setFirstName(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setFirstName("");
                                }
                                try {
                                    myCell = myRow.getCell(2);
                                    myImport.setMiddleName(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMiddleName("");
                                }
                                try {
                                    myCell = myRow.getCell(3);
                                    myImport.setLastName(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setLastName("");
                                }
                                try {
                                    myCell = myRow.getCell(4);
                                    myImport.setIdNumber(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setIdNumber("");
                                }
                                try {
                                    myCell = myRow.getCell(5);
                                    myImport.setPhoneNumber(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setPhoneNumber("");
                                }
                                try {
                                    myCell = myRow.getCell(6);
                                    myImport.setEmailAddress(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setEmailAddress("");
                                }
                                try {
                                    myCell = myRow.getCell(7);
                                    myImport.setDob(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setDob("");
                                }
                                try {
                                    myCell = myRow.getCell(8);
                                    myImport.setKraPin(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setKraPin("");
                                }
                                toImport.add((Object)myImport);
                                continue;
                            }
                            catch (NullPointerException myImport) {
                                // empty catch block
                            }
                        }
                        try {
                            FXMLLoader loader = new FXMLLoader();
                            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/confirmMemberImport.fxml").openStream());
                            Scene confirmImportScene = new Scene((Parent)itemPane, 1313.0, 600.0);
                            confirmImportScene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                                public void handle(KeyEvent t) {
                                    KeyCode key = t.getCode();
                                    if (key == KeyCode.ESCAPE) {
                                        confirmImport.close();
                                    }
                                }
                            });
                            confirmImport.setScene(confirmImportScene);
                            ConfirmMemberImport controller = (ConfirmMemberImport)loader.getController();
                            controller.setUser(AllMembersController.this.getUser());
                            controller.setDataSource((ObservableList<MemberImport>)toImport);
                            confirmImport.setTitle("Confirm Member Import");
                            confirmImport.setResizable(false);
                            confirmImport.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                                public void handle(WindowEvent event) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            AllMembersController.this.loadItems();
                                        }
                                    });
                                }
                            });
                            confirmImport.showAndWait();
                        }
                        catch (Exception p) {
                            p.printStackTrace();
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("An error occurred");
                            alert.setHeaderText("An error occurred while loading your confirm  member import screen. Please contact support");
                            alert.showAndWait();
                        }
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }));
        this.allMembers.setOnAction(e -> this.getAllMembers());
        this.memberStatement.setOnAction(e -> {
            try {
                Member tMember = (Member)this.allMembersTable.getSelectionModel().getSelectedItem();
                tMember.getMemberStatement(this.getUser());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            String searchString = newValue.trim().toLowerCase();
            ObservableList allMembers = FXCollections.observableArrayList();
            for (int b = 0; b < this.myMembers.size(); ++b) {
                Member current = (Member)this.myMembers.get(b);
                String myId = current.getIdNumber() + "";
                if (!current.getFullName().toLowerCase().contains(searchString) && !current.getMemberNumber().toLowerCase().contains(searchString) && !current.getPhoneNumber().toLowerCase().contains(searchString) && !myId.toLowerCase().contains(searchString)) continue;
                allMembers.add((Object)current);
            }
            this.allMembersTable.getItems().removeAll((Collection)this.allMembersTable.getItems());
            this.allMembersTable.setItems(allMembers);
        });
        this.refresh.setOnAction(e -> this.loadItems());
        this.delete.setOnAction(e -> {
            try {
                Member m = (Member)this.allMembersTable.getSelectionModel().getSelectedItem();
                String path = System.getProperty("user.dir");
                path = path.replace("\\", "/");
                String fileLocation = path + "/loading.gif";
                File file = new File(fileLocation);
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", m.getMemberNumber());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=member", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.loadItems();
                } else {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Could not delete");
                    alert.setHeaderText("The member could not be deleted");
                    alert.setContentText(myResponse.getMessage());
                    alert.showAndWait();
                }
            }
            catch (Exception t) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Could not delete");
                alert.setHeaderText("We encountered an error while deleting the member. Please try again later");
                alert.showAndWait();
            }
        });
        this.addMember.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/addMember.fxml").openStream());
                AddMemberController controller = (AddMemberController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Member");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllMembersController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allMembersTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Member rowData = (Member)row.getItem();
                    Member member = (Member)this.allMembersTable.getSelectionModel().getSelectedItem();
                    if (!member.equals(null)) {
                        this.editMember(member);
                    }
                }
            });
            return row;
        });
        this.editMember.setOnAction(r -> {
            try {
                Member xm = (Member)this.allMembersTable.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getMemberNumber().equals("")) {
                    this.editMember(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.allMembersTable.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.previewMember((Member)this.allMembersTable.getSelectionModel().getSelectedItem());
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.searchBar.setText("");
            this.loadItems();
        });
    }

    public void previewMember(Member myMember) {
        Platform.runLater(() -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", myMember.getMemberNumber());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterfetch?type=memberdetails", params, this.getUser());
                Member member = (Member)g.fromJson(response2, Member.class);
                this.previewName.setText(member.getFullName());
                this.previewIdNumber.setText(member.getIdNumber() + "");
                this.previewphoneNumber.setText(member.getPhoneNumber());
                this.previewEmailAddress.setText(member.getEmail());
                Image image = null;
                try {
                    BASE64Decoder decoder = new BASE64Decoder();
                    byte[] imageByte = decoder.decodeBuffer(member.getPhotoBlob());
                    ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
                    image = new Image((InputStream)bis);
                    this.previewProfilePhoto.setImage(image);
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        Platform.runLater(() -> {
            this.previewLoans.getItems().remove((Object)this.previewLoans.getItems());
            this.previewLoans.setItems(new Loan().getAllLoans(true, myMember.getMemberNumber(), this.getUser()));
        });
    }

    public void loadItems() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AllMembersController.this.masker.setVisible(true));
                ObservableList<Member> allMembers = new Member().getAllMembers(AllMembersController.this.getParams(), AllMembersController.this.getUser());
                AllMembersController.this.myMembers = new Member().getAllMembers(AllMembersController.this.getParams(), AllMembersController.this.getUser());
                AllMembersController.this.allMembersTable.setItems(allMembers);
                AllMembersController.this.allMembersTable.getSelectionModel().select(0);
                Platform.runLater(() -> AllMembersController.this.masker.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editMember(Member mMember) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/memberCard.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane, 782.0, 446.0);
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        editMemberStage.close();
                    }
                }
            });
            editMemberStage.setScene(editMember);
            EditMemberController controller = (EditMemberController)loader.getController();
            controller.setUser(this.getUser());
            controller.setMember(mMember);
            editMemberStage.setTitle("Edit Member");
            editMemberStage.setResizable(false);
            try {
                editMemberStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            editMemberStage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllMembersController.this.loadItems();
                        }
                    });
                }
            });
            editMemberStage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit member screen. Please contact support");
            alert.showAndWait();
        }
    }

    public void getAllMembers() {
        Platform.runLater(() -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("balances", 1);
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                new Config().getReport("All Members List", "masterfetch?type=members", params, "AllMembers.jasper", parameters2, this.getUser());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

