/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.AddUserController;
import controllers.EditUserController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class AllUsersController
implements Initializable {
    private User user;
    ObservableList<User> toSearch = FXCollections.observableArrayList();
    @FXML
    private VBox root;
    @FXML
    private JFXButton addUser;
    @FXML
    private JFXButton editUser;
    @FXML
    private JFXButton blockUser;
    @FXML
    private JFXButton activateUser;
    @FXML
    private JFXButton refresh;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    StackPane stackPane;
    @FXML
    NotificationPane notificationPane;
    @FXML
    private TableView<User> allUsers;
    @FXML
    private TableColumn userName;
    @FXML
    private TableColumn fullName;
    @FXML
    private TableColumn email;
    @FXML
    private TableColumn phone;
    @FXML
    private TableColumn lastLogin;
    @FXML
    private TableColumn userRole;
    @FXML
    private TableColumn status;
    @FXML
    private MaskerPane maskerPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadUsers();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.refresh.setOnAction(e -> this.loadUsers());
        this.notificationPane.setContent((Node)this.stackPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.addUser.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/adduser.fxml").openStream());
                AddUserController controller = (AddUserController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add User");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllUsersController.this.loadUsers();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.userName.setCellValueFactory((Callback)new PropertyValueFactory("userName"));
        this.fullName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.email.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.phone.setCellValueFactory((Callback)new PropertyValueFactory("phone"));
        this.lastLogin.setCellValueFactory((Callback)new PropertyValueFactory("lastSeen"));
        this.status.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.userRole.setCellValueFactory((Callback)new PropertyValueFactory("userRole"));
        this.allUsers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    User rowData = (User)row.getItem();
                    User user = (User)this.allUsers.getSelectionModel().getSelectedItem();
                    if (!user.equals(null)) {
                        this.editUser(user);
                    }
                }
            });
            return row;
        });
        this.editUser.setOnAction(r -> {
            try {
                User xm = (User)this.allUsers.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getUserName().equals("")) {
                    this.editUser(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals("")) {
                String searchString = this.search.getText().trim().toLowerCase();
                ObservableList afterSearch = FXCollections.observableArrayList();
                for (User current : this.toSearch) {
                    String tUserName = current.getUserName().trim().toLowerCase();
                    String tFullName = current.getFullName().trim().toLowerCase();
                    String tEmail = current.getEmail().trim().toLowerCase();
                    String tStatus = current.getStatus().trim().toLowerCase();
                    if (!tUserName.contains(searchString) && !tFullName.contains(searchString) && !tEmail.contains(searchString) && !tStatus.contains(searchString)) continue;
                    afterSearch.add((Object)current);
                }
                this.allUsers.getItems().clear();
                this.allUsers.setItems(afterSearch);
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadUsers();
        });
        this.activateUser.setOnAction(e -> {
            try {
                User selectedUser = (User)this.allUsers.getSelectionModel().getSelectedItem();
                String tUserName = selectedUser.getUserName();
                JsonResponses jr = new User().activateUser(selectedUser, this.getUser());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    this.loadUsers();
                }
            }
            catch (NullPointerException selectedUser) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.blockUser.setOnAction(e -> {
            try {
                User selectedUser = (User)this.allUsers.getSelectionModel().getSelectedItem();
                String tUserName = selectedUser.getUserName();
                JsonResponses jr = new User().blockUser(selectedUser, this.getUser());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    this.loadUsers();
                }
            }
            catch (NullPointerException selectedUser) {
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public void loadUsers() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AllUsersController.this.maskerPane.setVisible(true));
                AllUsersController.this.toSearch = new User().getAllUsers(AllUsersController.this.getUser());
                ObservableList<User> myUsers = new User().getAllUsers(AllUsersController.this.getUser());
                Platform.runLater(() -> {
                    AllUsersController.this.allUsers.setItems(myUsers);
                    AllUsersController.this.maskerPane.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editUser(User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/edituser.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            EditUserController controller = (EditUserController)loader.getController();
            controller.setUser(this.getUser());
            controller.setToEdit(user);
            stage.setTitle("Edit User");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllUsersController.this.loadUsers();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit user screen. Please contact support");
            alert.showAndWait();
        }
    }
}

