/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.AllowanceDeductionMatrix;
import classes.AllowancesDeductions;
import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AllocateAllowanceDeduction
implements Initializable {
    private boolean caretaker;
    private User user;
    private String type;
    private Employee employee;
    @FXML
    private NotificationPane notificationPane;
    public static NotificationPane publicNotificationPane = new NotificationPane();
    public static TableView<AllowanceDeductionMatrix> publicTable = new TableView();
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label employeeName;
    @FXML
    private ComboBox<Employee> employees;
    @FXML
    private Label addAllowancesDeductionLabel;
    @FXML
    private Label allowanceDeductionLabel;
    @FXML
    private ComboBox<AllowancesDeductions> allowanceDeduction;
    @FXML
    private ComboBox<String> calculationMethod;
    @FXML
    private TextField amountRate;
    @FXML
    private DatePicker startDate;
    @FXML
    private DatePicker endDate;
    @FXML
    private CheckBox disabled;
    @FXML
    private Button reset;
    @FXML
    private Button addAllowance;
    @FXML
    private TableView<AllowanceDeductionMatrix> allEntries;
    @FXML
    private TableColumn ColAllowanceDeduction;
    @FXML
    private TableColumn colCalculationMethod;
    @FXML
    private TableColumn colAmountRate;
    @FXML
    private TableColumn colStartDate;
    @FXML
    private TableColumn colEndDate;
    @FXML
    private TableColumn colDisabled;
    @FXML
    private TableColumn colDelete;
    @FXML
    private MaskerPane masker;
    @FXML
    private Button close;

    public boolean isCaretaker() {
        return this.caretaker;
    }

    public void setCaretaker(boolean caretaker) {
        this.caretaker = caretaker;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("exited", 0);
        params.put("caretaker", this.isCaretaker() ? 1 : 0);
        this.employees.setItems(new Employee().getAllEmployees(params, this.getUser()));
        this.loadAllowancesDeductions();
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
        String myType = this.getType();
        this.employeeName.setText(myType + " for Employee No: " + employee.getEmployeeNumber() + " Name: " + employee.getFullName());
        this.employees.setValue((Object)employee);
        this.generateEntries(this.getUser());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (type.equalsIgnoreCase("Earning")) {
            this.addAllowancesDeductionLabel.setText("Allowance");
            this.allowanceDeduction.setPromptText("Select Allowance");
            this.addAllowancesDeductionLabel.setText("Add Allowances");
            this.addAllowance.setText("Save Allowance");
            this.ColAllowanceDeduction.setText("Allowance");
            this.allowanceDeductionLabel.setText("Allowance");
        } else {
            this.addAllowancesDeductionLabel.setText("Deduction");
            this.allowanceDeduction.setPromptText("Select Deduction");
            this.addAllowancesDeductionLabel.setText("Add Deductions");
            this.addAllowance.setText("Save Deduction");
            this.ColAllowanceDeduction.setText("Deduction");
            this.allowanceDeductionLabel.setText("Deduction");
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        publicNotificationPane = this.notificationPane;
        publicTable = this.allEntries;
        this.startDate.setValue((Object)Config.getCurrentLocaldate());
        this.amountRate = new Config().setDoubleTextField(this.amountRate);
        ObservableList allMethods = FXCollections.observableArrayList();
        allMethods.add((Object)"Fixed Amount");
        allMethods.add((Object)"Percentage of Basic Salary");
        this.calculationMethod.setItems(allMethods);
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.employees.setOnAction(e -> {
            this.generateEntries(this.getUser());
            this.setEmployee((Employee)this.employees.getValue());
        });
        this.close.setOnAction(e -> {
            Stage stage = (Stage)this.close.getScene().getWindow();
            stage.close();
        });
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.allowanceDeduction, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.calculationMethod, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.amountRate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.startDate, Validator.createEmptyValidator((String)"Required"));
        this.reset.setOnAction(e -> this.clear());
        this.ColAllowanceDeduction.setCellValueFactory((Callback)new PropertyValueFactory("allowanceDeduction"));
        this.colCalculationMethod.setCellValueFactory((Callback)new PropertyValueFactory("calculationMethod"));
        this.colAmountRate.setCellValueFactory((Callback)new PropertyValueFactory("amountRateString"));
        this.colStartDate.setCellValueFactory((Callback)new PropertyValueFactory("startDate"));
        this.colEndDate.setCellValueFactory((Callback)new PropertyValueFactory("endDate"));
        this.colDisabled.setCellValueFactory((Callback)new PropertyValueFactory("disabledCheck"));
        this.colDelete.setCellValueFactory((Callback)new PropertyValueFactory("delete"));
        this.addAllowance.setOnAction(e -> {
            String tEmployeeNo = "";
            String tCode = "";
            String tCalculationMethod = "";
            double tAmountRate = 0.0;
            String tStartDate = "";
            String tEndDate = "";
            int tDisabled = this.disabled.isSelected() ? 1 : 0;
            boolean error = false;
            String message = "";
            String myType = this.getType();
            try {
                tEmployeeNo = ((Employee)this.employees.getValue()).getEmployeeNumber().trim();
                if (tEmployeeNo.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception t) {
                error = true;
                message = "Please select the employee being assigned the " + myType;
            }
            try {
                tCode = ((AllowancesDeductions)this.allowanceDeduction.getValue()).getCode().trim();
                if (tCode.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the " + myType;
            }
            try {
                tCalculationMethod = ((String)this.calculationMethod.getValue()).trim();
                if (tCalculationMethod.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the calculation method of the " + myType;
            }
            try {
                tAmountRate = Double.parseDouble(this.amountRate.getText().trim());
                if (tCalculationMethod.equalsIgnoreCase("Percentage of Basic Salary") && tAmountRate > 100.0) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Percentage rate cannot be greater than 100 ";
                }
            }
            catch (Exception y) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid amount/Rate of the " + myType;
            }
            try {
                tStartDate = Config.localDateToString((LocalDate)this.startDate.getValue());
            }
            catch (Exception u) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the start date of the " + myType;
            }
            try {
                tEndDate = Config.localDateToString((LocalDate)this.endDate.getValue());
                if (tEndDate.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception u) {
                tEndDate = null;
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("employeeNo", tEmployeeNo);
                    params.put("code", tCode);
                    params.put("calculationMethod", tCalculationMethod);
                    params.put("amountRate", tAmountRate);
                    params.put("startDate", tStartDate);
                    params.put("endDate", tEndDate);
                    params.put("disabled", tDisabled);
                    params.put("type", myType);
                    String response = Config.loadDataFromPhp("mastercreate?type=allowancedeductionmatrix", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                    if (jr.isStatus()) {
                        this.clear();
                        this.generateEntries(this.getUser());
                    }
                }
                catch (Exception y) {
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
    }

    public void generateEntries(final User user) {
        final String myType = this.getType();
        try {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> AllocateAllowanceDeduction.this.masker.setVisible(true));
                    ObservableList<AllowanceDeductionMatrix> myEntries = new AllowanceDeductionMatrix().getMatrix(myType, ((Employee)AllocateAllowanceDeduction.this.employees.getValue()).getEmployeeNumber(), user);
                    AllocateAllowanceDeduction.this.allEntries.setItems(myEntries);
                    Platform.runLater(() -> AllocateAllowanceDeduction.this.masker.setVisible(false));
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
            Thread thread1 = new Thread((Runnable)task1);
            thread1.setDaemon(true);
            thread1.start();
        }
        catch (Exception y) {
            this.notificationPane.setText("We encountered an error while loading the " + myType + ". Please try again later.");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void clear() {
        this.allowanceDeduction.setValue(null);
        this.calculationMethod.setValue(null);
        this.amountRate.setText(null);
        this.startDate.setValue((Object)Config.getCurrentLocaldate());
        this.endDate.setValue(null);
        this.disabled.setSelected(false);
    }

    public void loadAllowancesDeductions() {
        System.out.println("Loading allowances and deductions");
        try {
            String url = "masterfetch?type=payrollallowance";
            if (this.getType().equalsIgnoreCase("Deduction")) {
                url = "masterfetch?type=payrolldeduction";
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp(url, params, this.getUser());
            System.out.println(response);
            ObservableList allDed = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, AllowancesDeductions[].class)));
            this.allowanceDeduction.setItems(allDed);
        }
        catch (Exception y) {
            y.printStackTrace();
        }
    }
}

