/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.AllowancesDeductions;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class AllowancesController
implements Initializable {
    private User user;
    private AllowancesDeductions allowance;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label allowanceCode;
    @FXML
    private TextField allowanceName;
    @FXML
    private ComboBox<Account> glAccount;
    @FXML
    private Button searchAccount;
    @FXML
    private CheckBox taxable;
    @FXML
    private CheckBox disabled;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("category", 4);
        this.glAccount.setItems(new Account().getAccounts(user, params));
        this.save.setDisable(false);
    }

    public AllowancesDeductions getAllowance() {
        return this.allowance;
    }

    public void setAllowance(AllowancesDeductions allowance) {
        this.allowance = allowance;
        this.allowanceCode.setText(allowance.getCode());
        this.glAccount.setValue((Object)allowance.getGlAccount());
        this.allowanceName.setText(allowance.getName());
        this.taxable.setSelected(allowance.isTaxable());
        this.disabled.setSelected(allowance.isDisabled());
        this.save.setDisable(false);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(e -> this.save());
        this.searchAccount.setOnAction(e -> {
            Gson gson = new Gson();
            String response = new Config().getObjectFromSelection("glaccount", gson.toJson((Object)this.glAccount.getItems()), this.getUser());
            Account selected = (Account)gson.fromJson(response, Account.class);
            this.glAccount.setValue((Object)selected);
        });
    }

    public void save() {
        String tCode = "";
        String tName = "";
        String tGlAccount = "";
        int tTaxable = 0;
        int tDisabled = 0;
        boolean newAllowance = false;
        boolean error = false;
        String message = "";
        NumberSeries nb = new NumberSeries(26, this.getUser());
        try {
            tCode = this.allowanceCode.getText().trim();
            if (tCode.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            newAllowance = true;
            tCode = nb.getNextNumber();
        }
        try {
            tName = this.allowanceName.getText().trim();
            if (tName.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = "Please specify a name ";
        }
        try {
            tGlAccount = ((Account)this.glAccount.getValue()).getAccountNumber().trim();
            if (tGlAccount.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a G/L Account ";
        }
        tTaxable = this.taxable.isSelected() ? 1 : 0;
        int n = tDisabled = this.disabled.isSelected() ? 1 : 0;
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("allowanceCode", tCode);
                params.put("allowanceName", tName);
                params.put("allowanceGLAccount", tGlAccount);
                params.put("taxable", tTaxable);
                params.put("disabled", tDisabled);
                String url = newAllowance ? "mastercreate" : "masterupdate";
                String response = Config.loadDataFromPhp(url + "?type=payrollallowances", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    if (newAllowance) {
                        this.allowanceCode.setText(tCode);
                        nb.updateLastUsed(tCode);
                    }
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.save.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
    }
}

