/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.DriverConductor;
import classes.EmployeeBadge;
import classes.JsonResponses;
import classes.Member;
import classes.NumberSeries;
import classes.User;
import classes.Vehicle;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class BadgeApplicationController
implements Initializable {
    private User user;
    private DriverConductor driverConductor;
    private EmployeeBadge badge;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private HBox notificationHolder;
    @FXML
    private Label applicationNo;
    @FXML
    private ComboBox<DriverConductor> employee;
    @FXML
    private TextField employeePhone;
    @FXML
    private TextField employeeEmail;
    @FXML
    private ComboBox<String> position;
    @FXML
    private ComboBox<Member> employer;
    @FXML
    private Button chooseEmployer;
    @FXML
    private ComboBox<Vehicle> vehicle;
    @FXML
    private DatePicker applicationDate;
    @FXML
    private CheckBox badgeReceived;
    @FXML
    private DatePicker issuedOn;
    @FXML
    private DatePicker expiryDate;
    @FXML
    private CheckBox badgeIssued;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button apply;
    @FXML
    private TextField formApplicationAmount;
    @FXML
    private ComboBox<Bank> formApplicationBank;
    @FXML
    private TextField formApplicationDocNo;
    @FXML
    private TextField badgeCollectionAmount;
    @FXML
    private ComboBox<Bank> badgeCollectionBank;
    @FXML
    private TextField bankCollectionDocNo;
    @FXML
    private Button markReceived;
    @FXML
    private Button markCollected;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public EmployeeBadge getBadge() {
        return this.badge;
    }

    public void setBadge(EmployeeBadge badge) {
        this.badge = badge;
        try {
            this.applicationNo.setText(badge.getApplicationNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DriverConductor driverConductor = badge.getEmployee();
        try {
            this.employee.setValue((Object)driverConductor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeePhone.setText(driverConductor.getPhoneNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeeEmail.setText(driverConductor.getEmail());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.position.setValue((Object)badge.getPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employer.setValue((Object)badge.getEmployer());
            String memberNo = ((Member)this.employer.getValue()).getMemberNumber();
            ObservableList<Vehicle> myVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
            this.vehicle.setItems(myVehicles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.vehicle.setValue((Object)badge.getVehicle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.issuedOn.setValue((Object)Config.stringToLocalDate(badge.getIssuedOn()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeReceived.setSelected(badge.isBadgeReceived());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeIssued.setSelected(badge.isBadgeIssued());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.expiryDate.setValue((Object)Config.stringToLocalDate(badge.getExpiryDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.formApplicationAmount.setText(badge.getFormApplicationAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.formApplicationBank.setValue((Object)badge.getFormApplicationBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.formApplicationDocNo.setText(badge.getFormApplicationExternalDoc());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeCollectionAmount.setText(badge.getBadgeCollectionAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeCollectionBank.setValue((Object)badge.getBadgeCollectionBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bankCollectionDocNo.setText(badge.getBadgeCollectionExternalDoc());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeIssued.setSelected(badge.isBadgeIssued());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.badgeReceived.setSelected(badge.isBadgeReceived());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (badge.isApplied()) {
                this.badgeReceived.setDisable(false);
                this.badgeIssued.setDisable(false);
                this.markReceived.setDisable(false);
                this.markCollected.setDisable(false);
                this.employee.setDisable(true);
                this.position.setDisable(true);
                this.employer.setDisable(true);
                this.vehicle.setDisable(true);
                this.formApplicationBank.setDisable(true);
                this.formApplicationAmount.setDisable(true);
                this.formApplicationDocNo.setDisable(true);
                this.applicationDate.setDisable(true);
                this.apply.setDisable(true);
            }
            if (badge.isBadgeReceived()) {
                this.markReceived.setDisable(true);
            }
            if (badge.isBadgeIssued()) {
                this.markCollected.setDisable(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DriverConductor getDriverConductor() {
        return this.driverConductor;
    }

    public void setDriverConductor(DriverConductor driverConductor) {
        this.driverConductor = driverConductor;
        try {
            this.employee.setValue((Object)driverConductor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeePhone.setText(driverConductor.getPhoneNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employeeEmail.setText(driverConductor.getEmail());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.position.setValue((Object)driverConductor.getPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.employer.setValue((Object)driverConductor.getEmployer());
            String memberNo = ((Member)this.employer.getValue()).getMemberNumber();
            ObservableList<Vehicle> myVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
            this.vehicle.setItems(myVehicles);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.vehicle.setValue((Object)driverConductor.getVehicle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.applicationDate.setValue((Object)Config.getCurrentLocaldate());
        this.issuedOn.setOnAction(e -> {
            LocalDate issuedSelected1 = (LocalDate)this.issuedOn.getValue();
            this.expiryDate.setValue((Object)issuedSelected1.plusYears(1L));
        });
        this.badgeReceived.setOnAction(e -> {
            if (this.badgeReceived.isSelected()) {
                this.issuedOn.setDisable(false);
                this.expiryDate.setDisable(false);
                LocalDate today = Config.getCurrentLocaldate().minusDays(1L);
                this.issuedOn.setValue((Object)today);
                this.expiryDate.setValue((Object)today.plusYears(1L));
            }
        });
        this.badgeIssued.setOnAction(e -> {
            if (this.badgeIssued.isSelected()) {
                this.badgeCollectionAmount.setDisable(false);
                this.badgeCollectionBank.setDisable(false);
                this.bankCollectionDocNo.setDisable(false);
            }
        });
        this.badgeReceived.setDisable(true);
        this.issuedOn.setDisable(true);
        this.expiryDate.setDisable(true);
        this.badgeIssued.setDisable(true);
        this.badgeCollectionAmount.setDisable(true);
        this.badgeCollectionBank.setDisable(true);
        this.bankCollectionDocNo.setDisable(true);
        this.employeePhone.setDisable(true);
        this.employeeEmail.setDisable(true);
        this.markReceived.setDisable(true);
        this.markCollected.setDisable(true);
        this.employer.setItems(new Member().getAllMembers(this.getUser()));
        ObservableList allPositions = FXCollections.observableArrayList();
        allPositions.add((Object)"Driver");
        allPositions.add((Object)"Conductor");
        this.position.setItems(allPositions);
        ObservableList<Bank> allBanks = Bank.getAllBanks(this.getUser());
        this.formApplicationBank.setItems(allBanks);
        this.badgeCollectionBank.setItems(allBanks);
        ObservableList<DriverConductor> allEmployees = new DriverConductor().allEmployees(this.getUser());
        this.employee.setItems(allEmployees);
        this.employee.setOnAction(e -> {
            DriverConductor myEmployee = (DriverConductor)this.employee.getValue();
            this.setDriverConductor(myEmployee);
        });
        this.employer.setOnAction(e -> {
            String memberNo = ((Member)this.employer.getValue()).getMemberNumber();
            ObservableList<Vehicle> myVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
            this.vehicle.setItems(myVehicles);
        });
        this.chooseEmployer.setOnAction(e -> {
            try {
                Member m = new Member().getMemberFromSelection(this.getUser());
                String memberNo = m.getMemberNumber();
                this.employer.setValue((Object)m);
                ObservableList<Vehicle> myVehicles = new Vehicle().getMemberVehicles(memberNo, this.getUser());
                this.vehicle.setItems(myVehicles);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.save.setOnAction(e -> this.save());
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.apply.setOnAction(e -> {
            if (this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.apply.getScene().getWindow();
                stage.close();
            }
        });
        this.markReceived.setOnAction(e -> {
            if (this.markReceived()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.apply.getScene().getWindow();
                stage.close();
            }
        });
        this.markCollected.setOnAction(e -> {
            if (this.markCollected()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.apply.getScene().getWindow();
                stage.close();
            }
        });
        this.notificationPane.setContent((Node)this.notificationHolder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.employee, Validator.createEmptyValidator((String)"Employee is required"));
        vs.registerValidator((Control)this.employeePhone, Validator.createEmptyValidator((String)"Employee Phone No is required"));
        vs.registerValidator(this.position, Validator.createEmptyValidator((String)"Employee Position is required"));
        vs.registerValidator(this.employer, Validator.createEmptyValidator((String)"Employer is required"));
        vs.registerValidator(this.vehicle, Validator.createEmptyValidator((String)"Vehicle is required"));
    }

    public boolean save() {
        String tEmployeeNo = "";
        String tApplicationNo = "";
        String tEmployeeId = "";
        String tEmployeePhone = "";
        String tEmployeeEmail = this.employeeEmail.getText().trim();
        String tEmployeePosition = "";
        String tEmployeeEmployer = "";
        String tEmployeeVehicle = "";
        String tEmployeeIssuedOn = "";
        String tEmployeeExpiry = "";
        String tApplicationDate = "";
        double tFormApplicationAmount = 0.0;
        int tFormApplicationBank = 0;
        String tFormApplicationExternalDoc = "";
        double tBadgeCollectionAmount = 0.0;
        int tBadgeCollectionBank = 0;
        String tBadgeCollectionExternalDoc = "";
        boolean tBadgeReceived = this.badgeReceived.isSelected();
        boolean tBadgeIssued = this.badgeIssued.isSelected();
        boolean error = false;
        boolean newEmployee = false;
        String message = "";
        NumberSeries ns = new NumberSeries(20, this.getUser());
        try {
            tApplicationNo = this.applicationNo.getText().trim();
            if (tApplicationNo.equals(null) || tApplicationNo.equals("") || tApplicationNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tApplicationNo = ns.getNextNumber();
            newEmployee = true;
        }
        try {
            tEmployeeNo = ((DriverConductor)this.employee.getValue()).getEmployeeNo();
            if (tEmployeeNo.equals(null) || tEmployeeNo.equals("") || tEmployeeNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tEmployeeNo = ns.getNextNumber();
            newEmployee = true;
        }
        try {
            tEmployeeIssuedOn = Config.localDateToString((LocalDate)this.issuedOn.getValue());
        }
        catch (Exception t) {
            tEmployeeIssuedOn = "";
        }
        try {
            tEmployeeExpiry = Config.localDateToString((LocalDate)this.expiryDate.getValue());
        }
        catch (Exception t) {
            tEmployeeExpiry = "";
        }
        try {
            tApplicationDate = Config.localDateToString((LocalDate)this.applicationDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select a valid application date";
        }
        try {
            tEmployeePhone = this.employeePhone.getText().trim();
            if (tEmployeePhone.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid employee Phone Number";
        }
        try {
            tEmployeePosition = (String)this.position.getValue();
            if (tEmployeePosition.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the position the employee will be serving";
        }
        try {
            tEmployeeEmployer = ((Member)this.employer.getValue()).getMemberNumber();
            if (tEmployeeEmployer.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the person's employer";
        }
        try {
            tEmployeeVehicle = ((Vehicle)this.vehicle.getValue()).getRegNo();
            if (tEmployeeVehicle.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the vehicle ";
        }
        try {
            tFormApplicationAmount = Double.parseDouble(this.formApplicationAmount.getText().trim());
        }
        catch (Exception t) {
            tFormApplicationAmount = 0.0;
        }
        try {
            tFormApplicationBank = ((Bank)this.formApplicationBank.getValue()).getCode();
        }
        catch (Exception t) {
            tFormApplicationBank = 0;
        }
        tFormApplicationExternalDoc = this.formApplicationDocNo.getText().trim();
        try {
            tBadgeCollectionAmount = Double.parseDouble(this.badgeCollectionAmount.getText().trim());
        }
        catch (Exception t) {
            tBadgeCollectionAmount = 0.0;
        }
        try {
            tBadgeCollectionBank = ((Bank)this.badgeCollectionBank.getValue()).getCode();
        }
        catch (Exception t) {
            tBadgeCollectionBank = 0;
        }
        tBadgeCollectionExternalDoc = this.bankCollectionDocNo.getText().trim();
        if (!error) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applicationNo", tApplicationNo);
                params.put("employeeNo", tEmployeeNo);
                params.put("employeeId", tEmployeeId);
                params.put("employeePhone", tEmployeePhone);
                params.put("employeeEmail", tEmployeeEmail);
                params.put("employeePosition", tEmployeePosition);
                params.put("employer", tEmployeeEmployer);
                params.put("vehicle", tEmployeeVehicle);
                params.put("issuedOn", tEmployeeIssuedOn);
                params.put("applicationDate", tApplicationDate);
                params.put("formApplicationAmount", tFormApplicationAmount);
                params.put("formApplicationBank", tFormApplicationBank);
                params.put("formApplicationExternalDoc", tFormApplicationExternalDoc);
                params.put("badgeCollectionAmount", tBadgeCollectionAmount);
                params.put("badgeCollectionBank", tBadgeCollectionBank);
                params.put("badgeCollectionExternalDoc", tBadgeCollectionExternalDoc);
                params.put("expiryDate", tEmployeeExpiry);
                params.put("badgeReceived", tBadgeReceived ? 1 : 0);
                params.put("badgeIssued", tBadgeIssued ? 1 : 0);
                String response = Config.loadDataFromPhp("mastercreate?type=badgeapplication", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    if (newEmployee) {
                        this.applicationNo.setText(tApplicationNo);
                        ns.updateLastUsed(tApplicationNo);
                    }
                    return true;
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We experienced an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        } else {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        }
        return false;
    }

    public boolean post() {
        if (this.save()) {
            try {
                String tApplicationNo = this.applicationNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applicationNo", tApplicationNo);
                String response = Config.loadDataFromPhp("masterpost?type=badgeapplication", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean markReceived() {
        if (this.save()) {
            try {
                String tApplicationNo = this.applicationNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applicationNo", tApplicationNo);
                String response = Config.loadDataFromPhp("masterpost?type=badgereceived", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean markCollected() {
        if (this.save()) {
            try {
                String tApplicationNo = this.applicationNo.getText().trim();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applicationNo", tApplicationNo);
                String response = Config.loadDataFromPhp("masterpost?type=badgecollected", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                return jr.isStatus();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

