/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class BankLoanController
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private DatePicker loanDate;
    @FXML
    private TextField loanName;
    @FXML
    private TextField loanAmount;
    @FXML
    private TextField monthlyInstallments;
    @FXML
    private ComboBox<Bank> bankReceivingFunds;
    @FXML
    private Button createLoan;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.bankReceivingFunds.setItems(Bank.getAllBanks(user));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.loanDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.loanName, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.loanAmount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.monthlyInstallments, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.bankReceivingFunds, Validator.createEmptyValidator((String)"Required"));
        this.createLoan.setOnAction(e -> {
            String tDate = "";
            String tLoanName = "";
            double tLoanAmount = 0.0;
            double tMonthlyInstallments = 0.0;
            int bank = 0;
            String message = "";
            boolean error = false;
            try {
                tDate = Config.localDateToString((LocalDate)this.loanDate.getValue());
            }
            catch (Exception u) {
                message = "Please select the loan date";
                error = true;
            }
            try {
                tLoanName = this.loanName.getText().trim();
                if (tLoanName.length() < 4) {
                    throw new Exception();
                }
            }
            catch (Exception u) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the loan name";
                error = true;
            }
            try {
                tLoanAmount = Double.parseDouble(this.loanAmount.getText().trim());
            }
            catch (Exception u) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the loan amount";
                error = true;
            }
            try {
                tMonthlyInstallments = Double.parseDouble(this.monthlyInstallments.getText().trim());
            }
            catch (Exception u) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the monthly installments";
                error = true;
            }
            try {
                bank = ((Bank)this.bankReceivingFunds.getValue()).getCode();
            }
            catch (Exception u) {
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the monthly installments";
                error = true;
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("date", tDate);
                params.put("loanName", tLoanName);
                params.put("loanAmount", tLoanAmount);
                params.put("monthlyInstallments", tMonthlyInstallments);
                params.put("bank", bank);
                String response = Config.loadDataFromPhp("mastercreate?type=bank_loan", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.createLoan.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
    }
}

