/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.BankReconciliationEntries;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.NotificationPane;

public class BankReconciliationController
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label reconNumber;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private DatePicker fromDate;
    @FXML
    private DatePicker toDate;
    @FXML
    private Button uploadStatement;
    @FXML
    private TableView<BankReconciliationEntries> allEntries;
    @FXML
    private TableColumn date;
    @FXML
    private TableColumn description;
    @FXML
    private TableColumn system;
    @FXML
    private TableColumn bankStatement;
    @FXML
    private TableColumn matched;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.bank.setItems(Bank.getAllBanks(user));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.date.setCellValueFactory((Callback)new PropertyValueFactory("transactionDate"));
        this.description.setCellValueFactory((Callback)new PropertyValueFactory("narrative"));
        this.system.setCellValueFactory((Callback)new PropertyValueFactory("systemNetAmount"));
        this.bankStatement.setCellValueFactory((Callback)new PropertyValueFactory("statementNetAmount"));
        this.matched.setCellValueFactory((Callback)new PropertyValueFactory("matched"));
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.uploadStatement.setOnAction(r -> {
            block20: {
                if (this.save()) {
                    FileChooser chooser = new FileChooser();
                    chooser.setTitle("Select Excel to Import Transactions from");
                    chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx"})});
                    try {
                        File file = chooser.showOpenDialog((Window)new Stage());
                        boolean newVoucher = false;
                        if (file == null) break block20;
                        try {
                            XSSFWorkbook wb = new XSSFWorkbook(file);
                            XSSFSheet ws = wb.getSheetAt(0);
                            int limit = 0;
                            limit = ws.getPhysicalNumberOfRows();
                            for (int a = 1; a < limit; ++a) {
                                String[] dateDetails;
                                Cell myCell;
                                XSSFRow myRow = ws.getRow(a);
                                System.out.println("Running Line " + a + " of " + limit);
                                String transactionDate = "";
                                String valueDate = "";
                                String transactionRef = "";
                                String channelRefId = "";
                                String narrative = "";
                                double debit = 0.0;
                                double credit = 0.0;
                                SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd");
                                try {
                                    myCell = myRow.getCell(0);
                                    dateDetails = myCell.toString().split("-");
                                    transactionDate = dateDetails[2] + "-" + dateDetails[1] + "-" + dateDetails[0];
                                }
                                catch (Exception t) {
                                    transactionDate = "";
                                    t.printStackTrace();
                                }
                                try {
                                    myCell = myRow.getCell(1);
                                    dateDetails = myCell.toString().split("-");
                                    valueDate = dateDetails[2] + "-" + dateDetails[1] + "-" + dateDetails[0];
                                }
                                catch (Exception t) {
                                    t.printStackTrace();
                                    valueDate = "";
                                }
                                try {
                                    myCell = myRow.getCell(2);
                                    transactionRef = myCell.toString();
                                }
                                catch (Exception t) {
                                    transactionRef = "";
                                }
                                try {
                                    myCell = myRow.getCell(3);
                                    channelRefId = myCell.toString();
                                }
                                catch (Exception t) {
                                    channelRefId = "";
                                }
                                try {
                                    myCell = myRow.getCell(4);
                                    narrative = myCell.toString();
                                }
                                catch (Exception t) {
                                    narrative = "";
                                }
                                try {
                                    myCell = myRow.getCell(5);
                                    String debitValue = myCell.toString().trim();
                                    System.out.println(debitValue);
                                    debitValue = debitValue.replace(",", "");
                                    debit = Double.parseDouble(debitValue);
                                }
                                catch (Exception t) {
                                    t.printStackTrace();
                                    debit = 0.0;
                                }
                                try {
                                    myCell = myRow.getCell(6);
                                    String creditValue = myCell.toString().trim();
                                    System.out.println(creditValue);
                                    creditValue = creditValue.replace(",", "");
                                    credit = Double.parseDouble(creditValue);
                                }
                                catch (Exception t) {
                                    t.printStackTrace();
                                    credit = 0.0;
                                }
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                params.put("reconNumber", this.reconNumber.getText().trim());
                                params.put("transactionDate", transactionDate);
                                params.put("valueDate", valueDate);
                                params.put("transactionRef", transactionRef);
                                params.put("channelRefId", channelRefId);
                                params.put("narrative", narrative);
                                params.put("debit", debit);
                                params.put("credit", credit);
                                String response = Config.loadDataFromPhp("mastercreate?type=bankrecstatement", params, this.user);
                                System.out.println(response);
                            }
                            this.loadEntries();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    catch (Exception p) {
                        p.printStackTrace();
                    }
                }
            }
        });
    }

    public boolean save() {
        String tRecNo = "";
        String tBankCode = "";
        String tFromDate = "";
        String tToDate = "";
        String message = "";
        boolean error = false;
        try {
            tBankCode = ((Bank)this.bank.getValue()).getCode() + "";
            if (tBankCode.length() == 0) {
                throw new Exception();
            }
        }
        catch (Exception p) {
            error = true;
            message = "Please select the bank to reconcile";
        }
        try {
            tFromDate = Config.localDateToString((LocalDate)this.fromDate.getValue());
        }
        catch (Exception p) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the start date";
        }
        try {
            tToDate = Config.localDateToString((LocalDate)this.toDate.getValue());
        }
        catch (Exception p) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the end date";
        }
        if (!error) {
            NumberSeries ns = new NumberSeries(62, this.getUser());
            boolean newRecord = false;
            try {
                tRecNo = this.reconNumber.getText().trim();
                if (tRecNo.length() == 0) {
                    throw new Exception();
                }
            }
            catch (Exception o) {
                newRecord = true;
                tRecNo = ns.getNextNumber();
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("recNo", tRecNo);
            params.put("bankCode", tBankCode);
            params.put("fromDate", tFromDate);
            params.put("toDate", tToDate);
            String response = Config.loadDataFromPhp("mastercreate?type=bankreconciliation", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus() && newRecord) {
                this.reconNumber.setText(tRecNo);
                ns.updateLastUsed(tRecNo);
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        this.notificationPane.setText(message);
        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
        this.notificationPane.show();
        return false;
    }

    public void loadEntries() {
        this.allEntries.setItems(new BankReconciliationEntries().getAllEntries(this.reconNumber.getText().trim(), this.getUser()));
    }
}

